/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp.driver;

import com4j.COM4J;
import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.TypeLibInfo;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.driver.Messages;
import java.io.File;

public final class Lib {
    private GUID libid;
    private String libver;
    private String packageName = null;
    private File file;
    private boolean suppress = false;

    public void setLibid(String libid) {
        this.libid = new GUID(libid);
    }

    public void setLibid(GUID libid) {
        this.libid = libid;
    }

    public void setLibver(String ver) {
        this.libver = ver;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void setSuppress(boolean b) {
        this.suppress = b;
    }

    public void setFile(File file) {
        this.file = file;
        if (file != null && !file.exists()) {
            throw new IllegalArgumentException(Messages.NO_SUCH_FILE.format(file));
        }
    }

    public File getFile() throws BindingException {
        if (this.file == null) {
            TypeLibInfo tli = TypeLibInfo.locate(this.libid, this.libver);
            this.file = tli.typeLibrary;
        }
        return this.file;
    }

    public String getPackage() {
        return this.packageName;
    }

    public boolean suppress() {
        return this.suppress;
    }

    public GUID getLibid() {
        if (this.libid == null) {
            IWTypeLib tlb = (IWTypeLib)COM4J.loadTypeLibrary((File)this.file).queryInterface(IWTypeLib.class);
            this.libid = tlb.getLibid();
            tlb.dispose();
        }
        return this.libid;
    }

    void validate() {
        if (this.libid == null && this.file == null) {
            throw new IllegalArgumentException("either libid or file must be set");
        }
    }
}

