/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp.driver;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.CodeWriter;
import com4j.tlbimp.ErrorListener;
import com4j.tlbimp.Generator;
import com4j.tlbimp.ReferenceResolver;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.driver.Lib;
import com4j.tlbimp.driver.Messages;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

final class Driver {
    private final Map<GUID, Lib> libs = new HashMap<GUID, Lib>();
    private String packageName = "";
    private Locale locale = Locale.getDefault();
    boolean renameGetterAndSetters = false;
    boolean alwaysUseComEnums = false;
    boolean generateDefaultMethodOverloads = false;

    Driver() {
    }

    public void addLib(Lib r) {
        this.libs.put(r.getLibid(), r);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setLocale(String locale) {
        String[] tokens = locale.split("_");
        this.locale = new Locale(tokens.length > 0 ? tokens[0] : "", tokens.length > 1 ? tokens[1] : "", tokens.length > 2 ? tokens[2] : "");
    }

    public void run(CodeWriter cw, final ErrorListener el) throws BindingException, IOException {
        final HashSet<Com4jObject> libsToGen = new HashSet<Com4jObject>();
        for (Lib lib : this.libs.values()) {
            libsToGen.add(COM4J.loadTypeLibrary((File)lib.getFile()).queryInterface(IWTypeLib.class));
        }
        ReferenceResolver resolver = new ReferenceResolver(){

            public String resolve(IWTypeLib lib) {
                String pkg;
                GUID libid = lib.getLibid();
                if (Driver.this.libs.containsKey(libid) && (pkg = ((Lib)Driver.this.libs.get(libid)).getPackage()) != null) {
                    return pkg;
                }
                if (libid.equals((Object)GUID.GUID_STDOLE)) {
                    return "";
                }
                if (libsToGen.add(lib)) {
                    el.warning(Messages.REFERENCED_TYPELIB_GENERATED.format(lib.getName(), Driver.this.packageName));
                }
                return Driver.this.packageName;
            }

            public boolean suppress(IWTypeLib lib) {
                GUID libid = lib.getLibid();
                if (libid.equals((Object)GUID.GUID_STDOLE)) {
                    return true;
                }
                Lib r = (Lib)Driver.this.libs.get(libid);
                if (r != null) {
                    return r.suppress();
                }
                return false;
            }
        };
        Generator generator = new Generator(cw, resolver, el, this.locale);
        generator.setAlwaysUseComEnums(this.alwaysUseComEnums);
        generator.setRenameGetterAndSetters(this.renameGetterAndSetters);
        generator.setGenerateDefaultMethodOverloads(this.generateDefaultMethodOverloads);
        HashSet<IWTypeLib> generatedLibs = new HashSet<IWTypeLib>();
        while (!generatedLibs.containsAll(libsToGen)) {
            HashSet s = new HashSet(libsToGen);
            s.removeAll(generatedLibs);
            for (IWTypeLib lib : s) {
                el.started(lib);
                generator.generate(lib);
                generatedLibs.add(lib);
            }
        }
        generator.finish();
    }
}

