/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp.driver;

import com4j.ComException;
import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.ErrorListener;
import com4j.tlbimp.FileCodeWriter;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.driver.Driver;
import com4j.tlbimp.driver.Lib;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntTaskImpl
extends Task
implements ErrorListener {
    private File destDir;
    private File source;
    private GUID libid;
    private String libver;
    private Driver driver = new Driver();
    private boolean hasLib = false;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setPackage(String packageName) {
        this.driver.setPackageName(packageName);
    }

    public void setFile(File source) {
        this.source = source;
    }

    public void setLibid(String libid) {
        this.libid = new GUID(libid);
    }

    public void setLibver(String libver) {
        this.libver = libver;
    }

    public void setLocale(String locale) {
        this.driver.setLocale(locale);
    }

    public void setRenameGetterAndSetters(boolean renameGetterAndSetters) {
        this.driver.renameGetterAndSetters = renameGetterAndSetters;
    }

    public void setAlwaysUseComEnums(boolean alwaysUseComEnums) {
        this.driver.alwaysUseComEnums = alwaysUseComEnums;
    }

    public void setGenerateDefaultMethodOverloads(boolean v) {
        this.driver.generateDefaultMethodOverloads = v;
    }

    public void addConfiguredLib(Lib r) {
        r.validate();
        this.driver.addLib(r);
        this.hasLib = true;
    }

    public void execute() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("@destDir is missing");
        }
        if (this.source != null || this.libid != null) {
            Lib lib = new Lib();
            lib.setLibid(this.libid);
            lib.setLibver(this.libver);
            lib.setFile(this.source);
            this.addConfiguredLib(lib);
        }
        if (!this.hasLib) {
            throw new BuildException("No type library is specified");
        }
        try {
            this.driver.run(new FileCodeWriter(this.destDir), this);
        }
        catch (ComException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (BindingException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void started(IWTypeLib lib) {
        this.log("Generating definitions from " + lib.getName(), 2);
    }

    public void error(BindingException e) {
        this.log(e.getMessage(), 0);
    }

    public void warning(String message) {
        this.log(message, 1);
    }
}

