/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.COM4J;
import com4j.ComException;
import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.Messages;
import com4j.tlbimp.Native;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public final class TypeLibInfo {
    public final String libName;
    public final File typeLibrary;
    public final Version version;
    public final int lcid;

    public TypeLibInfo(String libName, File typeLibrary, Version version, int lcid) {
        this.libName = libName;
        this.typeLibrary = typeLibrary;
        this.version = version;
        this.lcid = lcid;
    }

    public static TypeLibInfo locate(GUID libid, String version) throws BindingException {
        String fileName;
        String libName;
        COM4J.IID_IUnknown.toString();
        if (libid == null) {
            throw new IllegalArgumentException();
        }
        String libKey = "TypeLib\\" + libid;
        try {
            Native.readRegKey(libKey);
        }
        catch (ComException e) {
            throw new BindingException(Messages.INVALID_LIBID.format(libid), e);
        }
        if (version == null) {
            ArrayList<Version> versions = new ArrayList<Version>();
            for (String v : Native.enumRegKeys(libKey)) {
                versions.add(new Version(v));
            }
            Collections.sort(versions);
            if (versions.size() == 0) {
                throw new BindingException(Messages.NO_VERSION_AVAILABLE.format(new Object[0]));
            }
            version = ((Version)versions.get(versions.size() - 1)).toString();
        }
        String verKey = "TypeLib\\" + libid + "\\" + version;
        try {
            libName = Native.readRegKey(verKey);
        }
        catch (ComException e) {
            throw new BindingException(Messages.INVALID_VERSION.format(version), e);
        }
        HashSet<Integer> lcids = new HashSet<Integer>();
        for (String lcid : Native.enumRegKeys(verKey)) {
            try {
                lcids.add(Integer.valueOf(lcid));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int lcid = lcids.contains(0) ? 0 : (Integer)lcids.iterator().next();
        try {
            fileName = Native.readRegKey(verKey + "\\" + lcid + "\\win32");
        }
        catch (ComException e) {
            throw new BindingException(Messages.NO_WIN32_TYPELIB.format(libid, version), e);
        }
        return new TypeLibInfo(libName, new File(fileName), new Version(version), lcid);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Version
    implements Comparable<Version> {
        public final int major;
        public final int minor;
        public final String version;

        public Version(String name) {
            int idx = name.indexOf(46);
            this.major = Integer.valueOf(name.substring(0, idx), 16);
            this.minor = Integer.valueOf(name.substring(idx + 1), 16);
            this.version = name;
        }

        @Override
        public int compareTo(Version rhs) {
            if (this.major != rhs.major) {
                return this.major - rhs.major;
            }
            return this.minor - rhs.minor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version version = (Version)o;
            if (this.major != version.major) {
                return false;
            }
            return this.minor == version.minor;
        }

        public int hashCode() {
            return 29 * this.major + this.minor;
        }

        public String toString() {
            return this.version;
        }
    }
}

