/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.NativeType;
import com4j.stdole.IFontDisp;
import com4j.stdole.IPictureDisp;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.Generator;
import com4j.tlbimp.Messages;
import com4j.tlbimp.def.ICoClassDecl;
import com4j.tlbimp.def.IDispInterfaceDecl;
import com4j.tlbimp.def.IEnumDecl;
import com4j.tlbimp.def.IInterfaceDecl;
import com4j.tlbimp.def.IPrimitiveType;
import com4j.tlbimp.def.IPtrType;
import com4j.tlbimp.def.ISafeArrayType;
import com4j.tlbimp.def.IType;
import com4j.tlbimp.def.ITypeDecl;
import com4j.tlbimp.def.ITypedefDecl;
import com4j.tlbimp.def.VarType;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeBinding {
    public final String javaType;
    public final NativeType nativeType;
    public final boolean isDefault;
    private static final Map<String, String> boxTypeMap = new HashMap<String, String>();
    private static final Map<VarType, TypeBinding> primitiveTypeBindings;

    public TypeBinding(Class<?> javaType, NativeType nativeType, boolean isDefault) {
        this(javaType.getName(), nativeType, isDefault);
    }

    public TypeBinding(String javaType, NativeType nativeType, boolean isDefault) {
        this.javaType = javaType;
        this.nativeType = nativeType;
        this.isDefault = isDefault;
    }

    public TypeBinding createByRef() {
        String t = this.javaType;
        if (boxTypeMap.containsKey(t)) {
            t = boxTypeMap.get(t);
        }
        return new TypeBinding("Holder<" + t + ">", this.nativeType.byRef(), this.isDefault);
    }

    public static TypeBinding bind(Generator g, IType t, String nameHint) throws BindingException {
        ITypedefDecl typedef;
        ISafeArrayType at;
        IPrimitiveType pt = (IPrimitiveType)t.queryInterface(IPrimitiveType.class);
        if (pt != null) {
            TypeBinding r = primitiveTypeBindings.get((Object)pt.getVarType());
            if (r != null) {
                return r;
            }
            throw new BindingException(Messages.UNSUPPORTED_VARTYPE.format(new Object[]{pt.getVarType()}));
        }
        IPtrType ptrt = (IPtrType)t.queryInterface(IPtrType.class);
        if (ptrt != null) {
            String name;
            IType comp = ptrt.getPointedAtType();
            IInterfaceDecl compDecl = (IInterfaceDecl)comp.queryInterface(IInterfaceDecl.class);
            if (compDecl != null) {
                return new TypeBinding(g.getTypeName(compDecl), NativeType.ComObject, true);
            }
            IDispInterfaceDecl dispDecl = (IDispInterfaceDecl)comp.queryInterface(IDispInterfaceDecl.class);
            if (dispDecl != null) {
                return new TypeBinding(g.getTypeName(dispDecl), NativeType.ComObject, true);
            }
            ICoClassDecl classdecl = (ICoClassDecl)comp.queryInterface(ICoClassDecl.class);
            if (classdecl != null) {
                ITypeDecl di = g.getDefaultInterface(classdecl);
                if (di == null) {
                    return new TypeBinding(Com4jObject.class, NativeType.ComObject, true);
                }
                return new TypeBinding(g.getTypeName(di), NativeType.ComObject, true);
            }
            IPrimitiveType compPrim = (IPrimitiveType)comp.queryInterface(IPrimitiveType.class);
            if (compPrim != null) {
                if (compPrim.getVarType() == VarType.VT_VARIANT) {
                    return new TypeBinding(Object.class, NativeType.VARIANT_ByRef, true);
                }
                if (compPrim.getVarType() == VarType.VT_VOID) {
                    return new TypeBinding(Buffer.class, NativeType.PVOID, true);
                }
                if (compPrim.getVarType() == VarType.VT_UI2 && TypeBinding.isPsz(nameHint)) {
                    return new TypeBinding(String.class, NativeType.Unicode, false);
                }
                if (compPrim.getVarType() == VarType.VT_BOOL) {
                    return new TypeBinding("Holder<Boolean>", NativeType.VariantBool_ByRef, true);
                }
            }
            if ((name = TypeBinding.getTypeString(ptrt)).equals("_RemotableHandle*")) {
                return new TypeBinding(Integer.TYPE, NativeType.Int32, true);
            }
            if (name.equals("GUID*")) {
                return new TypeBinding("GUID", NativeType.GUID, true);
            }
            TypeBinding b = TypeBinding.bind(g, comp, null);
            if (b != null && b.nativeType.byRef() != null) {
                return b.createByRef();
            }
        }
        if ((at = (ISafeArrayType)t.queryInterface(ISafeArrayType.class)) != null) {
            TypeBinding r;
            IType comp = at.getComponentType();
            IPrimitiveType compPrim = (IPrimitiveType)comp.queryInterface(IPrimitiveType.class);
            if (compPrim != null && (r = primitiveTypeBindings.get((Object)compPrim.getVarType())) != null) {
                return new TypeBinding(r.javaType + "[]", NativeType.SafeArray, true);
            }
            TypeBinding tb = TypeBinding.bind(g, comp, null);
            if (tb.nativeType == NativeType.VARIANT) {
                return new TypeBinding("Object[]", NativeType.SafeArray, true);
            }
        }
        if ((typedef = (ITypedefDecl)t.queryInterface(ITypedefDecl.class)) != null) {
            return TypeBinding.bind(g, typedef.getDefinition(), nameHint);
        }
        IEnumDecl enumdef = (IEnumDecl)t.queryInterface(IEnumDecl.class);
        if (enumdef != null) {
            return new TypeBinding(g.getTypeName(enumdef), NativeType.Int32, true);
        }
        String name = TypeBinding.getTypeString(t);
        if (name.equals("GUID")) {
            return new TypeBinding("GUID", NativeType.GUID, true);
        }
        IDispInterfaceDecl disp = (IDispInterfaceDecl)t.queryInterface(IDispInterfaceDecl.class);
        if (disp != null) {
            if (disp.getGUID().equals((Object)COM4J.IID_IPictureDisp)) {
                return new TypeBinding(IPictureDisp.class, NativeType.ComObject, true);
            }
            if (disp.getGUID().equals((Object)COM4J.IID_IFontDisp)) {
                return new TypeBinding(IFontDisp.class, NativeType.ComObject, true);
            }
            throw new BindingException(Messages.UNSUPPORTED_TYPE.format(TypeBinding.getTypeString(t)));
        }
        ITypeDecl declt = (ITypeDecl)t.queryInterface(ITypeDecl.class);
        if (declt != null) {
            throw new BindingException(Messages.UNSUPPORTED_TYPE.format(TypeBinding.getTypeString(t)));
        }
        throw new BindingException(Messages.UNSUPPORTED_TYPE.format(TypeBinding.getTypeString(t)));
    }

    private static String getTypeString(IType t) {
        if (t == null) {
            return "null";
        }
        IPtrType pt = (IPtrType)t.queryInterface(IPtrType.class);
        if (pt != null) {
            return TypeBinding.getTypeString(pt.getPointedAtType()) + "*";
        }
        IPrimitiveType prim = (IPrimitiveType)t.queryInterface(IPrimitiveType.class);
        if (prim != null) {
            return prim.getName();
        }
        ITypeDecl decl = (ITypeDecl)t.queryInterface(ITypeDecl.class);
        if (decl != null) {
            return decl.getName();
        }
        ISafeArrayType sa = (ISafeArrayType)t.queryInterface(ISafeArrayType.class);
        if (sa != null) {
            return "SAVEARRAY(" + TypeBinding.getTypeString(sa.getComponentType()) + ")";
        }
        return "N/A";
    }

    private static void pbind(VarType vt, Class<?> c, NativeType n, boolean isDefault) {
        primitiveTypeBindings.put(vt, new TypeBinding(c, n, isDefault));
    }

    private static boolean isPsz(String hint) {
        if (hint == null) {
            return false;
        }
        return hint.startsWith("psz") || hint.startsWith("lpsz");
    }

    static {
        boxTypeMap.put("byte", "Byte");
        boxTypeMap.put("short", "Short");
        boxTypeMap.put("int", "Integer");
        boxTypeMap.put("long", "Long");
        boxTypeMap.put("float", "Float");
        boxTypeMap.put("double", "Double");
        boxTypeMap.put("boolean", "Boolean");
        boxTypeMap.put("char", "Character");
        primitiveTypeBindings = new EnumMap<VarType, TypeBinding>(VarType.class);
        TypeBinding.pbind(VarType.VT_I1, Byte.TYPE, NativeType.Int8, true);
        TypeBinding.pbind(VarType.VT_I2, Short.TYPE, NativeType.Int16, true);
        TypeBinding.pbind(VarType.VT_I4, Integer.TYPE, NativeType.Int32, true);
        TypeBinding.pbind(VarType.VT_I8, Long.TYPE, NativeType.Int64, true);
        TypeBinding.pbind(VarType.VT_BSTR, String.class, NativeType.BSTR, true);
        TypeBinding.pbind(VarType.VT_LPSTR, String.class, NativeType.CSTR, false);
        TypeBinding.pbind(VarType.VT_LPWSTR, String.class, NativeType.Unicode, false);
        TypeBinding.pbind(VarType.VT_UI1, Byte.TYPE, NativeType.Int8, true);
        TypeBinding.pbind(VarType.VT_UI2, Short.TYPE, NativeType.Int16, true);
        TypeBinding.pbind(VarType.VT_UI4, Integer.TYPE, NativeType.Int32, true);
        TypeBinding.pbind(VarType.VT_UI8, Long.TYPE, NativeType.Int64, true);
        TypeBinding.pbind(VarType.VT_INT, Integer.TYPE, NativeType.Int32, true);
        TypeBinding.pbind(VarType.VT_HRESULT, Integer.TYPE, NativeType.Int32, true);
        TypeBinding.pbind(VarType.VT_UINT, Integer.TYPE, NativeType.Int32, true);
        TypeBinding.pbind(VarType.VT_BOOL, Boolean.TYPE, NativeType.VariantBool, true);
        TypeBinding.pbind(VarType.VT_R4, Float.TYPE, NativeType.Float, true);
        TypeBinding.pbind(VarType.VT_R8, Double.TYPE, NativeType.Double, true);
        TypeBinding.pbind(VarType.VT_VARIANT, Object.class, NativeType.VARIANT, false);
        TypeBinding.pbind(VarType.VT_DISPATCH, Com4jObject.class, NativeType.Dispatch, false);
        TypeBinding.pbind(VarType.VT_UNKNOWN, Com4jObject.class, NativeType.ComObject, true);
        TypeBinding.pbind(VarType.VT_DATE, Date.class, NativeType.Date, true);
        TypeBinding.pbind(VarType.VT_CY, BigDecimal.class, NativeType.Currency, false);
        TypeBinding.pbind(VarType.VT_VOID, Void.TYPE, NativeType.Bool, true);
    }
}

