/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.ComException;
import com4j.GUID;
import com4j.NativeType;
import com4j.Variant;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.Escape;
import com4j.tlbimp.Generator;
import com4j.tlbimp.IndentingWriter;
import com4j.tlbimp.Messages;
import com4j.tlbimp.TypeBinding;
import com4j.tlbimp.def.IMethod;
import com4j.tlbimp.def.IParam;
import com4j.tlbimp.def.IPrimitiveType;
import com4j.tlbimp.def.IPtrType;
import com4j.tlbimp.def.IType;
import com4j.tlbimp.def.InvokeKind;
import com4j.tlbimp.def.VarType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MethodBinder {
    protected final IMethod method;
    protected final IParam[] params;
    protected final int retParam;
    protected final IType returnType;
    protected final Generator g;
    private static final Set<String> reservedMethods = new HashSet<String>();

    protected MethodBinder(Generator g, IMethod method) throws BindingException {
        this.g = g;
        this.method = method;
        int len = method.getParamCount();
        this.params = new IParam[len];
        for (int i = 0; i < len; ++i) {
            this.params[i] = method.getParam(i);
        }
        this.retParam = this.getReturnParam();
        this.returnType = this.getReturnTypeBinding();
    }

    protected IType getReturnTypeBinding() throws BindingException {
        if (this.retParam == -1) {
            return null;
        }
        IPtrType pt = (IPtrType)this.params[this.retParam].getType().queryInterface(IPtrType.class);
        if (pt == null) {
            throw new BindingException(Messages.RETVAL_MUST_BY_REFERENCE.format(new Object[0]));
        }
        return pt.getPointedAtType();
    }

    private int getReturnParam() {
        for (int i = 0; i < this.params.length; ++i) {
            if (!this.params[i].isRetval()) continue;
            return i;
        }
        int outIdx = -1;
        for (int i = 0; i < this.params.length; ++i) {
            if (!this.params[i].isOut() || this.params[i].isIn()) continue;
            if (outIdx == -1) {
                outIdx = i;
                continue;
            }
            return -1;
        }
        return outIdx;
    }

    public void declare(IndentingWriter o) throws BindingException {
        Parameter[] defaultParams = this.generateDefaults();
        boolean[] useDefault = new boolean[defaultParams.length];
        for (int i = 0; i < useDefault.length; ++i) {
            useDefault[i] = defaultParams[i] != null;
        }
        for (int pos = 0; this.g.generateDefaultMethodOverloads && pos < useDefault.length; ++pos) {
            if (!useDefault[pos]) continue;
            this.declareWithDefaults(o, defaultParams, useDefault);
            useDefault[pos] = false;
        }
        this.declareWithDefaults(o, defaultParams, null);
    }

    private Parameter[] generateDefaults() {
        Parameter[] defParam = new Parameter[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            TypeBinding vb;
            if (!this.params[i].isOptional()) continue;
            try {
                vb = TypeBinding.bind(this.g, this.params[i].getType(), this.params[i].getName());
            }
            catch (BindingException e) {
                this.g.el.error(e);
                continue;
            }
            defParam[i] = new Parameter();
            Variant defValue = this.params[i].getDefaultValue();
            defParam[i].nativeType = vb.nativeType;
            defParam[i].javaTypeName = vb.javaType;
            if (defValue != null) {
                defParam[i].variantType = defValue.getType();
                defParam[i].literal = defValue.getParseableString();
                defParam[i].javaCode = defValue.getJavaCode();
                continue;
            }
            defValue = Variant.getMissing();
            switch (vb.nativeType) {
                case Bool: 
                case VariantBool: 
                case VariantBool_ByRef: {
                    defParam[i].javaCode = defParam[i].literal = "false";
                    break;
                }
                case BSTR: 
                case BSTR_ByRef: 
                case CSTR: 
                case Unicode: {
                    defParam[i].literal = "";
                    defParam[i].javaCode = "\"\"";
                    break;
                }
                case Int8: 
                case Int8_ByRef: {
                    defParam[i].literal = "0";
                    defParam[i].javaCode = "(byte) " + defParam[i].literal;
                    break;
                }
                case Int16: 
                case Int16_ByRef: {
                    defParam[i].literal = "0";
                    defParam[i].javaCode = "(short) " + defParam[i].literal;
                    break;
                }
                case Int32: 
                case Int32_ByRef: {
                    defParam[i].javaCode = defParam[i].literal = "0";
                    break;
                }
                case Int64: 
                case Int64_ByRef: {
                    defParam[i].literal = "0";
                    defParam[i].javaCode = defParam[i].literal + "L";
                    break;
                }
                case Float: 
                case Float_ByRef: {
                    defParam[i].literal = "0";
                    defParam[i].javaCode = defParam[i].literal + ".0f";
                    break;
                }
                case Double: 
                case Double_ByRef: {
                    defParam[i].javaCode = defParam[i].literal = "0.0";
                    break;
                }
                case GUID: {
                    defParam[i].javaCode = defParam[i].literal = GUID.GUID_NULL.toString();
                    break;
                }
                case VARIANT: 
                case VARIANT_ByRef: {
                    defParam[i].literal = defValue.getParseableString();
                    defParam[i].javaCode = defValue.getJavaCode();
                    break;
                }
                default: {
                    defParam[i].javaCode = defParam[i].literal = null;
                }
            }
            defParam[i].variantType = vb.nativeType == NativeType.VARIANT ? defValue.getType() : Variant.Type.NO_TYPE;
        }
        return defParam;
    }

    private void declareJavaDoc(IndentingWriter o, Parameter[] defaultParam, boolean[] useDefault) {
        int i;
        o.beginJavaDocMode();
        String helpString = this.method.getHelpString();
        if (helpString != null) {
            o.println("<p>");
            o.println(helpString);
            o.println("</p>");
        }
        if (this.method.getKind() == InvokeKind.PROPERTYGET) {
            o.println("<p>");
            o.println("Getter method for the COM property \"" + this.method.getName() + "\"");
            o.println("</p>");
        }
        if (this.method.getKind() == InvokeKind.PROPERTYPUT || this.method.getKind() == InvokeKind.PROPERTYPUTREF) {
            o.println("<p>");
            o.println("Setter method for the COM property \"" + this.method.getName() + "\"");
            o.println("</p>");
        }
        if (useDefault != null) {
            o.println("<p>");
            o.println("This method uses predefined default values for the following parameters:");
            o.println("</p>");
            o.println("<ul>");
            o.in();
            for (i = 0; i < defaultParam.length; ++i) {
                if (!useDefault[i]) continue;
                o.print("<li>" + defaultParam[i].javaTypeName + " parameter ");
                this.declareParamName(o, this.params[i]);
                o.print(" is set to " + defaultParam[i].javaCode + "</li>");
            }
            o.out();
            o.println("</ul>");
            o.println("<p>");
            o.println("Therefore, using this method is equivalent to");
            o.println("<code>");
            this.declareMethodName(o);
            o.print("(");
            boolean first = true;
            for (int i2 = 0; i2 < defaultParam.length; ++i2) {
                if (i2 == this.retParam) continue;
                if (!first) {
                    o.print(", ");
                } else {
                    first = false;
                }
                if (useDefault[i2]) {
                    o.print(defaultParam[i2].javaCode);
                    continue;
                }
                this.declareParamName(o, this.params[i2]);
            }
            o.println(");");
            o.println("</code>");
            o.println("</p>");
        }
        for (i = 0; i < this.params.length; ++i) {
            IParam p = this.params[i];
            if (this.retParam != -1 && p == this.params[this.retParam] && !p.isIn() || useDefault != null && useDefault[i]) continue;
            o.print("@param ");
            this.declareParamName(o, p);
            if (p.isOptional()) {
                o.print(" Optional parameter.");
                if (defaultParam[i].javaCode != null) {
                    o.print(" Default value is " + defaultParam[i].javaCode);
                } else {
                    o.print(" Default value is unprintable.");
                }
            } else {
                try {
                    TypeBinding tb = TypeBinding.bind(this.g, this.params[i].getType(), this.params[i].getName());
                    o.print(" Mandatory " + tb.javaType + " parameter.");
                }
                catch (BindingException e) {
                    o.print(" Mandatory parameter.");
                }
            }
            o.println();
        }
        if (this.getReturnParam() >= 0 && !MethodBinder.isEnum(this.method)) {
            o.print("@return ");
            try {
                TypeBinding tb = TypeBinding.bind(this.g, this.getReturnTypeBinding(), null);
                o.println(" Returns a value of type " + tb.javaType);
            }
            catch (BindingException e) {
                o.println();
            }
        }
        o.endJavaDocMode();
        o.println();
    }

    private void declareWithDefaults(IndentingWriter o, Parameter[] defaultParam, boolean[] useDefault) throws BindingException {
        this.declareJavaDoc(o, defaultParam, useDefault);
        this.annotate(o);
        int dispId = this.method.getDispId();
        if (dispId == 0) {
            o.println("@DefaultMethod");
        }
        if (useDefault != null) {
            String paramIndexMappings = "paramIndexMapping = {";
            String optParamIndices = "optParamIndex = {";
            String javaTypes = "javaType = {";
            String nativeTypes = "nativeType = {";
            String variantTypes = "variantType = {";
            String literals = "literal = {";
            boolean firstDefault = true;
            boolean firstJavaParam = true;
            for (int i = 0; i < defaultParam.length; ++i) {
                if (useDefault[i]) {
                    if (!firstDefault) {
                        optParamIndices = optParamIndices + ", ";
                        javaTypes = javaTypes + ", ";
                        nativeTypes = nativeTypes + ", ";
                        variantTypes = variantTypes + ", ";
                        literals = literals + ", ";
                    } else {
                        firstDefault = false;
                    }
                    optParamIndices = optParamIndices + i;
                    javaTypes = javaTypes + defaultParam[i].toClassName() + ".class";
                    nativeTypes = nativeTypes + "NativeType." + defaultParam[i].nativeType.name();
                    variantTypes = variantTypes + "Variant.Type." + defaultParam[i].variantType.name();
                    literals = literals + '\"' + defaultParam[i].literal + '\"';
                    continue;
                }
                if (!firstJavaParam) {
                    paramIndexMappings = paramIndexMappings + ", ";
                } else {
                    firstJavaParam = false;
                }
                paramIndexMappings = paramIndexMappings + i;
            }
            paramIndexMappings = paramIndexMappings + "}";
            optParamIndices = optParamIndices + "}";
            javaTypes = javaTypes + "}";
            nativeTypes = nativeTypes + "}";
            variantTypes = variantTypes + "}";
            literals = literals + "}";
            String defaultsAnnotation = "@UseDefaultValues(" + MethodBinder.join(Arrays.asList(paramIndexMappings, optParamIndices, javaTypes, nativeTypes, variantTypes, literals), ", ") + ')';
            o.println(defaultsAnnotation);
        }
        if (MethodBinder.isEnum(this.method)) {
            o.println("java.util.Iterator<Com4jObject> iterator();");
            return;
        }
        this.declareReturnType(o, null, useDefault != null);
        this.declareMethodName(o);
        this.declareParameters(o, useDefault);
        o.println();
    }

    private static String join(Collection<?> args, String delim) {
        StringBuilder buf = new StringBuilder();
        for (Object arg : args) {
            if (buf.length() > 0) {
                buf.append(delim);
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    protected void annotate(IndentingWriter o) {
    }

    protected final void declareMethodName(IndentingWriter o) {
        String name;
        String methodName = this.method.getName();
        if (this.g.renameGetterAndSetters) {
            String methodStart = methodName.length() > 3 ? methodName.substring(0, 3) : "";
            switch (this.method.getKind()) {
                case PROPERTYGET: {
                    if (methodStart.equalsIgnoreCase("get")) break;
                    methodName = "get" + methodName.substring(0, 1).toUpperCase(this.g.locale) + methodName.substring(1);
                    break;
                }
                case PROPERTYPUT: 
                case PROPERTYPUTREF: {
                    if (methodStart.equalsIgnoreCase("put")) {
                        methodName = "set" + methodName.substring(3);
                        break;
                    }
                    if (methodStart.equalsIgnoreCase("set")) break;
                    methodName = "set" + methodName.substring(0, 1).toUpperCase(this.g.locale) + methodName.substring(1);
                }
            }
        }
        if (reservedMethods.contains(name = MethodBinder.escape(this.camelize(methodName)))) {
            name = name + '_';
        }
        o.print(name);
    }

    protected final void declareParameters(IndentingWriter o, boolean[] useDefaults) throws BindingException {
        o.print('(');
        o.in();
        boolean first = true;
        for (int i = 0; i < this.params.length; ++i) {
            if (useDefaults != null && useDefaults[i]) continue;
            IParam p = this.params[i];
            if (this.retParam != -1 && p == this.params[this.retParam] && !p.isIn()) continue;
            if (!first) {
                o.println(',');
            } else {
                o.println();
            }
            first = false;
            this.declare(o, p);
        }
        o.out();
        o.print(")");
        this.terminate(o);
    }

    protected abstract void terminate(IndentingWriter var1);

    private void declare(IndentingWriter o, IParam p) throws BindingException {
        Variant defValue;
        TypeBinding vb = TypeBinding.bind(this.g, p.getType(), p.getName());
        String javaType = vb.javaType;
        if (this.method.isVarArg() && p == this.params[this.params.length - 1] && javaType.endsWith("[]")) {
            javaType = javaType.substring(0, javaType.length() - 2) + "...";
        }
        if (p.isOptional()) {
            o.print("@Optional ");
        }
        if ((defValue = p.getDefaultValue()) != null) {
            try {
                o.print("@DefaultValue(\"" + defValue.stringValue() + "\") ");
            }
            catch (ComException e) {
                // empty catch block
            }
        }
        if (p.isLCID()) {
            o.print("@LCID ");
        }
        if (!vb.isDefault && this.needsMarshalAs()) {
            o.printf("@MarshalAs(NativeType.%1s) ", vb.nativeType.name());
        }
        o.print(javaType);
        o.print(' ');
        this.declareParamName(o, p);
    }

    protected void declareParamName(IndentingWriter o, IParam p) {
        String name = p.getName();
        if (name == null) {
            name = "rhs";
        }
        o.print(MethodBinder.escape(this.camelize(name)));
    }

    protected boolean needsMarshalAs() {
        return false;
    }

    protected final void declareReturnType(IndentingWriter o, List<IType> intermediates, boolean usesDefaltValues) throws BindingException {
        this.generateAccessModifier(o);
        if (this.returnType == null && intermediates == null) {
            o.print("void ");
        } else {
            TypeBinding retBinding = TypeBinding.bind(this.g, this.returnType, null);
            if (!retBinding.isDefault && this.needsMarshalAs() || this.retParam != -1 && (this.params[this.retParam].isIn() || this.retParam != this.params.length - 1) || intermediates != null || usesDefaltValues) {
                o.print("@ReturnValue(");
                o.beginCommaMode();
                if (!retBinding.isDefault && this.needsMarshalAs()) {
                    o.comma();
                    o.print("type=NativeType." + retBinding.nativeType.name());
                }
                if (this.retParam != -1 && this.params[this.retParam].isIn()) {
                    o.comma();
                    o.print("inout=true");
                }
                if (this.retParam != -1 && this.retParam != this.params.length - 1 || usesDefaltValues) {
                    o.comma();
                    o.print("index=" + this.retParam);
                }
                if (intermediates != null) {
                    o.comma();
                    o.print("defaultPropertyThrough={");
                    o.beginCommaMode();
                    for (IType im : intermediates) {
                        TypeBinding vb = TypeBinding.bind(this.g, im, null);
                        o.comma();
                        o.print(vb.javaType);
                        o.print(".class");
                    }
                    o.endCommaMode();
                    o.print("}");
                }
                o.endCommaMode();
                o.println(")");
            }
            o.print(retBinding.javaType);
            o.print(' ');
        }
    }

    protected void generateAccessModifier(IndentingWriter o) {
    }

    private static String escape(String s) {
        return Escape.escape(s);
    }

    private String camelize(String s) {
        int idx;
        for (idx = 0; idx < s.length() && Character.isUpperCase(s.charAt(idx)); ++idx) {
        }
        if (idx == s.length()) {
            return s.toLowerCase(this.g.locale);
        }
        if (idx > 0) {
            if (idx == 1) {
                idx = 2;
            }
            return s.substring(0, idx - 1).toLowerCase(this.g.locale) + s.substring(idx - 1);
        }
        return s;
    }

    static boolean isEnum(IMethod m) {
        return m.getName().equals("_NewEnum");
    }

    protected final IType getDispInterfaceReturnType() {
        IType r = this.method.getReturnType();
        IPrimitiveType pt = (IPrimitiveType)r.queryInterface(IPrimitiveType.class);
        if (pt != null && pt.getVarType() == VarType.VT_HRESULT) {
            return null;
        }
        return r;
    }

    static {
        reservedMethods.add("equals");
        reservedMethods.add("getClass");
        reservedMethods.add("hashCode");
        reservedMethods.add("notify");
        reservedMethods.add("notifyAll");
        reservedMethods.add("toString");
        reservedMethods.add("wait");
    }

    class Parameter {
        String javaTypeName;
        NativeType nativeType;
        Variant.Type variantType;
        String literal;
        String javaCode;

        Parameter() {
        }

        public String toClassName() {
            int idx = this.javaTypeName.indexOf(60);
            if (idx >= 0) {
                return this.javaTypeName.substring(0, idx);
            }
            return this.javaTypeName;
        }
    }
}

