/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.tlbimp.BindingException;
import com4j.tlbimp.Generator;
import com4j.tlbimp.IndentingWriter;
import com4j.tlbimp.InterfaceGenerator;
import com4j.tlbimp.MethodBinder;
import com4j.tlbimp.def.IDispInterfaceDecl;
import com4j.tlbimp.def.IInterface;
import com4j.tlbimp.def.IInterfaceDecl;
import com4j.tlbimp.def.IMethod;
import com4j.tlbimp.def.IPtrType;
import com4j.tlbimp.def.IType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class InvocableInterfaceGenerator<T extends IInterface>
extends InterfaceGenerator<T> {
    protected InvocableInterfaceGenerator(Generator.LibBinder lib, T t) {
        super(lib, t);
    }

    @Override
    protected final String getClassDecl() {
        return "public interface";
    }

    @Override
    protected final void generateMethod(IMethod m, IndentingWriter o) throws BindingException {
        try {
            MethodBinderImpl mb = this.createMethodBinder(m);
            if (mb == null) {
                return;
            }
            mb.declare(o);
            o.println();
            mb.generateDefaultInterfaceFacade(o);
        }
        catch (BindingException e) {
            e.addContext("method " + m.getName());
            throw e;
        }
    }

    @Override
    protected final void generateExtends(IndentingWriter o) {
        boolean hasEnum = false;
        for (int j = 0; j < this.t.countMethods() && !hasEnum; ++j) {
            IMethod m = this.t.getMethod(j);
            hasEnum = MethodBinder.isEnum(m);
        }
        List<String> baseTypes = this.getBaseTypes();
        if (baseTypes.isEmpty()) {
            baseTypes.add("Com4jObject");
        }
        if (hasEnum) {
            baseTypes.add("Iterable<Com4jObject>");
        }
        o.print(" extends ");
        o.beginCommaMode();
        for (String name : baseTypes) {
            o.comma();
            o.print(name);
        }
        o.endCommaMode();
    }

    protected abstract MethodBinderImpl createMethodBinder(IMethod var1) throws BindingException;

    protected abstract class MethodBinderImpl
    extends MethodBinder {
        protected MethodBinderImpl(Generator g, IMethod method) throws BindingException {
            super(g, method);
        }

        protected final void terminate(IndentingWriter o) {
            o.println(";");
        }

        final void generateDefaultInterfaceFacade(IndentingWriter o) throws BindingException {
            MethodBinderImpl mb;
            IMethod m = this.method;
            ArrayList<IType> intermediates = new ArrayList<IType>();
            while (true) {
                IInterfaceDecl intf;
                mb = InvocableInterfaceGenerator.this.createMethodBinder(m);
                if (m.getParamCount() != 1 || mb.retParam != 0 || mb.params[mb.retParam].isIn() || MethodBinder.isEnum(m)) break;
                IPtrType pt = (IPtrType)mb.returnType.queryInterface(IPtrType.class);
                IDispInterfaceDecl di = null;
                IInterfaceDecl ii = null;
                if (pt != null) {
                    IType t = pt.getPointedAtType();
                    di = (IDispInterfaceDecl)t.queryInterface(IDispInterfaceDecl.class);
                    ii = (IInterfaceDecl)t.queryInterface(IInterfaceDecl.class);
                }
                if (di == null && ii == null) break;
                if (ii != null) {
                    intf = ii;
                } else {
                    if (!di.isDual()) break;
                    intf = di.getVtblInterface();
                }
                IMethod dm = this.g.dmf.getDefaultMethod(intf);
                if (dm == null) {
                    return;
                }
                m = dm;
                intermediates.add(pt);
            }
            if (intermediates.isEmpty()) {
                return;
            }
            if (m.getParamCount() < 2) {
                return;
            }
            if (InvocableInterfaceGenerator.this.createMethodBinder((IMethod)m).retParam < 0) {
                return;
            }
            o.printf("@VTID(%1d)", this.method.getVtableIndex());
            o.println();
            mb = InvocableInterfaceGenerator.this.createMethodBinder(m);
            mb.declareReturnType(o, intermediates, false);
            this.declareMethodName(o);
            mb.declareParameters(o, null);
            o.println();
        }
    }
}

