/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.Generator;
import com4j.tlbimp.IndentingWriter;
import com4j.tlbimp.def.IInterface;
import com4j.tlbimp.def.IMethod;
import com4j.tlbimp.def.IProperty;
import com4j.tlbimp.def.ITypeDecl;
import com4j.tlbimp.def.InvokeKind;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class InterfaceGenerator<T extends IInterface> {
    protected final T t;
    protected final Generator g;
    protected final Generator.LibBinder lib;
    protected final String simpleName;

    protected InterfaceGenerator(Generator.LibBinder lib, T t) {
        this.t = t;
        this.lib = lib;
        this.g = lib.parent();
        this.simpleName = lib.getSimpleTypeName((ITypeDecl)t);
    }

    protected String getSubPackageName() {
        return null;
    }

    protected final void generate() throws IOException {
        String pkg = this.getSubPackageName();
        IndentingWriter o = this.lib.createWriter((pkg != null ? pkg + '/' : "") + this.simpleName + ".java");
        this.lib.generateHeader(o, pkg);
        o.printJavadoc(this.t.getHelpString());
        o.printf("@IID(\"%1s\")", this.getIID());
        o.println();
        o.printf("%1s %2s", this.getClassDecl(), this.simpleName);
        this.generateExtends(o);
        o.println(" {");
        o.in();
        o.println("// Methods:");
        HashSet<String> putMethods = new HashSet<String>();
        for (int j = 0; j < this.t.countMethods(); ++j) {
            IMethod m = this.t.getMethod(j);
            InvokeKind kind = m.getKind();
            if ((kind == InvokeKind.PROPERTYPUT || kind == InvokeKind.PROPERTYPUTREF) && !putMethods.add(m.getName())) continue;
            try {
                o.startBuffering();
                this.generateMethod(m, o);
                o.commit();
            }
            catch (BindingException e) {
                o.cancel();
                e.addContext("interface " + this.t.getName());
                this.g.el.error(e);
            }
            m.dispose();
        }
        o.println("// Properties:");
        for (int i = 0; i < this.t.countProperties(); ++i) {
            try {
                o.startBuffering();
                this.generateProperty(this.t.getProperty(i), o);
                o.commit();
                continue;
            }
            catch (BindingException e) {
                o.cancel();
                e.addContext("interface " + this.t.getName());
                this.g.el.error(e);
            }
        }
        o.out();
        o.println("}");
        o.close();
    }

    protected void generateExtends(IndentingWriter o) {
    }

    protected abstract String getClassDecl();

    protected abstract List<String> getBaseTypes();

    protected abstract GUID getIID();

    protected abstract void generateMethod(IMethod var1, IndentingWriter var2) throws BindingException;

    protected abstract void generateProperty(IProperty var1, IndentingWriter var2) throws BindingException;
}

