/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.tlbimp.CancellableWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;

public class IndentingWriter
extends PrintWriter {
    private int indentSize = 2;
    private String indentString = null;
    private int indent = 0;
    private boolean newLine = true;
    private boolean needsComma;
    private final Stack<Boolean> commaStack = new Stack();
    private boolean javaDocMode = false;

    public IndentingWriter(Writer out) {
        super(new CancellableWriter(out));
        this.initializeIndentString();
    }

    public IndentingWriter(Writer out, boolean autoFlush) {
        super((Writer)new CancellableWriter(out), autoFlush);
        this.initializeIndentString();
    }

    private CancellableWriter getOut() {
        return (CancellableWriter)this.out;
    }

    private void initializeIndentString() {
        StringBuffer sb = new StringBuffer(this.indentSize);
        for (int i = 0; i < this.indentSize; ++i) {
            sb.append(' ');
        }
        this.indentString = sb.toString();
    }

    public void startBuffering() {
        try {
            this.getOut().mark();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancel() {
        this.getOut().cancel();
    }

    public void commit() {
        try {
            this.getOut().commit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void in() {
        ++this.indent;
    }

    public void out() {
        --this.indent;
    }

    private void printIndent() {
        try {
            for (int i = 0; i < this.indent; ++i) {
                this.out.write(this.indentString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkIndent() {
        if (this.newLine) {
            this.printIndent();
            if (this.javaDocMode) {
                try {
                    this.out.write(" * ");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.newLine = false;
    }

    public void beginCommaMode() {
        this.commaStack.push(this.needsComma);
        this.needsComma = false;
    }

    public void endCommaMode() {
        this.needsComma |= this.commaStack.pop().booleanValue();
    }

    public void comma() {
        if (this.needsComma) {
            this.print(',');
            this.needsComma = false;
        }
    }

    public void beginJavaDocMode() {
        assert (!this.javaDocMode);
        if (this.javaDocMode) {
            System.err.println("Waring: Already in JavaDocMode!");
        }
        this.println("/**");
        this.javaDocMode = true;
    }

    public void endJavaDocMode() {
        assert (this.javaDocMode);
        if (!this.javaDocMode) {
            System.err.println("Waring: Wasn't in JavaDocMode!");
        }
        this.javaDocMode = false;
        this.println(" */");
    }

    public void println() {
        super.println();
        this.newLine = true;
    }

    public void write(int c) {
        this.checkIndent();
        this.needsComma = true;
        super.write(c);
    }

    public void write(char[] buf, int off, int len) {
        this.checkIndent();
        this.needsComma = true;
        super.write(buf, off, len);
    }

    public void write(String s, int off, int len) {
        this.checkIndent();
        this.needsComma = true;
        super.write(s, off, len);
    }

    public void printJavadoc(String doc) {
        if (doc != null) {
            this.beginJavaDocMode();
            this.println(doc);
            this.endJavaDocMode();
        }
    }
}

