/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.Com4jObject;
import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.CodeWriter;
import com4j.tlbimp.CustomInterfaceGenerator;
import com4j.tlbimp.DefaultMethodFinder;
import com4j.tlbimp.DispInterfaceGenerator;
import com4j.tlbimp.ErrorListener;
import com4j.tlbimp.EventInterfaceGenerator;
import com4j.tlbimp.IndentingWriter;
import com4j.tlbimp.Messages;
import com4j.tlbimp.ReferenceResolver;
import com4j.tlbimp.def.ICoClassDecl;
import com4j.tlbimp.def.IConstant;
import com4j.tlbimp.def.IDispInterfaceDecl;
import com4j.tlbimp.def.IEnumDecl;
import com4j.tlbimp.def.IImplementedInterfaceDecl;
import com4j.tlbimp.def.IInterfaceDecl;
import com4j.tlbimp.def.ITypeDecl;
import com4j.tlbimp.def.ITypedefDecl;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.def.TypeKind;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class Generator {
    private final CodeWriter writer;
    private final ReferenceResolver referenceResolver;
    protected final ErrorListener el;
    final DefaultMethodFinder dmf = new DefaultMethodFinder();
    final Locale locale;
    private final Set<LibBinder> generatedTypeLibs = new HashSet<LibBinder>();
    boolean renameGetterAndSetters = false;
    boolean alwaysUseComEnums = false;
    boolean generateDefaultMethodOverloads = true;
    private final Map<String, Package> packages = new HashMap<String, Package>();
    private final Map<IWTypeLib, LibBinder> typeLibs = new HashMap<IWTypeLib, LibBinder>();
    private static final Set<GUID> STDOLE_TYPES = new HashSet<GUID>(Arrays.asList(new GUID("00000000-0000-0000-C000-000000000046"), new GUID("00020400-0000-0000-C000-000000000046")));

    public Generator(CodeWriter writer, ReferenceResolver resolver, ErrorListener el, Locale locale) {
        this.el = el;
        this.writer = writer;
        this.referenceResolver = resolver;
        this.locale = locale;
    }

    public void setRenameGetterAndSetters(boolean renameGetterAndSetters) {
        this.renameGetterAndSetters = renameGetterAndSetters;
    }

    public void setAlwaysUseComEnums(boolean alwaysUseComEnums) {
        this.alwaysUseComEnums = alwaysUseComEnums;
    }

    public void setGenerateDefaultMethodOverloads(boolean v) {
        this.generateDefaultMethodOverloads = v;
    }

    public void generate(IWTypeLib lib) throws BindingException, IOException {
        LibBinder tli = this.getTypeLibInfo(lib);
        if (this.referenceResolver.suppress(lib)) {
            return;
        }
        if (this.generatedTypeLibs.add(tli)) {
            tli.generate();
        }
    }

    public void finish() throws IOException {
        for (Package pkg : this.packages.values()) {
            LibBinder lib1 = pkg.typeLibs.iterator().next();
            if (this.referenceResolver.suppress(lib1.lib)) continue;
            IndentingWriter o = pkg.createWriter(lib1, "ClassFactory.java");
            lib1.generateHeader(o);
            o.printJavadoc("Defines methods to create COM objects");
            o.println("public abstract class ClassFactory {");
            o.in();
            o.println("private ClassFactory() {} // instanciation is not allowed");
            o.println();
            for (LibBinder lib : pkg.typeLibs) {
                int len = lib.lib.count();
                for (int i = 0; i < len; ++i) {
                    ICoClassDecl t = (ICoClassDecl)lib.lib.getType(i).queryInterface(ICoClassDecl.class);
                    if (t == null || !t.isCreatable()) continue;
                    this.declareFactoryMethod(o, t);
                    t.dispose();
                }
            }
            o.out();
            o.println("}");
            o.close();
        }
    }

    ITypeDecl getDefaultInterface(ICoClassDecl t) {
        int count = t.countImplementedInterfaces();
        for (int i = 0; i < count; ++i) {
            IImplementedInterfaceDecl impl = t.getImplementedInterface(i);
            if (impl.isSource() || !impl.isDefault()) continue;
            IInterfaceDecl c = this.getCustom(impl);
            if (c != null) {
                return c;
            }
            IDispInterfaceDecl d = (IDispInterfaceDecl)impl.getType().queryInterface(IDispInterfaceDecl.class);
            if (d == null) continue;
            return d;
        }
        HashSet<IInterfaceDecl> types = new HashSet<IInterfaceDecl>();
        for (int i = 0; i < count; ++i) {
            IInterfaceDecl c;
            IImplementedInterfaceDecl impl = t.getImplementedInterface(i);
            if (impl.isSource() || (c = this.getCustom(impl)) == null) continue;
            types.add(c);
        }
        if (types.isEmpty()) {
            return null;
        }
        HashSet<Com4jObject> bases = new HashSet<Com4jObject>();
        for (IInterfaceDecl ii : types) {
            for (int i = 0; i < ii.countBaseInterfaces(); ++i) {
                bases.add(ii.getBaseInterface(i).queryInterface(IInterfaceDecl.class));
            }
        }
        types.removeAll(bases);
        return (ITypeDecl)types.iterator().next();
    }

    private IInterfaceDecl getCustom(IImplementedInterfaceDecl impl) {
        ITypeDecl t = impl.getType();
        IInterfaceDecl ii = (IInterfaceDecl)t.queryInterface(IInterfaceDecl.class);
        if (ii != null) {
            return ii;
        }
        IDispInterfaceDecl di = (IDispInterfaceDecl)t.queryInterface(IDispInterfaceDecl.class);
        if (di.isDual()) {
            return di.getVtblInterface();
        }
        return null;
    }

    private void declareFactoryMethod(IndentingWriter o, ICoClassDecl t) {
        ITypeDecl p = this.getDefaultInterface(t);
        String primaryIntf = Com4jObject.class.getName();
        try {
            if (p != null) {
                primaryIntf = this.getTypeName(p);
            }
        }
        catch (BindingException e) {
            e.addContext("class factory for coclass " + t.getName());
            this.el.error(e);
        }
        o.println();
        o.printJavadoc(t.getHelpString());
        o.printf("public static %1s create%2s() {", primaryIntf, t.getName());
        o.println();
        o.in();
        o.printf("return COM4J.createInstance( %1s.class, \"%2s\" );", primaryIntf, t.getGUID());
        o.println();
        o.out();
        o.println("}");
    }

    private Package getPackage(String name) {
        Package p = this.packages.get(name);
        if (p == null) {
            p = new Package(name);
            this.packages.put(name, p);
        }
        return p;
    }

    String getTypeName(ITypeDecl decl) throws BindingException {
        LibBinder tli = this.getTypeLibInfo(decl.getParent());
        String pkgName = tli.pkg.name;
        String name = tli.getSimpleTypeName(decl);
        if (pkgName.equals("com4j.stdole")) {
            if (name.equals("Com4jObject")) {
                return name;
            }
            return pkgName + "." + name;
        }
        if (pkgName.length() > 0) {
            pkgName = pkgName + '.';
        }
        return pkgName + name;
    }

    private LibBinder getTypeLibInfo(IWTypeLib p) throws BindingException {
        LibBinder tli = this.typeLibs.get(p);
        if (tli == null) {
            tli = new LibBinder(p);
            this.typeLibs.put(p, tli);
        }
        return tli;
    }

    final class LibBinder {
        final IWTypeLib lib;
        final Package pkg;
        private final Map<ITypeDecl, String> aliases = new HashMap<ITypeDecl, String>();
        private Set<ITypeDecl> eventInterfaces = new HashSet<ITypeDecl>();

        public LibBinder(IWTypeLib lib) throws BindingException {
            this.lib = lib;
            this.pkg = Generator.this.getPackage(Generator.this.referenceResolver.resolve(lib));
            this.pkg.typeLibs.add(this);
            this.buildSimpleAliasTable();
        }

        private void buildSimpleAliasTable() {
            String prefix = this.pkg.name;
            if (prefix.length() == 0) {
                prefix = prefix + '.';
            }
            int len = this.lib.count();
            for (int i = 0; i < len; ++i) {
                ITypedefDecl typedef;
                ITypeDecl def;
                ITypeDecl t = this.lib.getType(i);
                if (t.getKind() == TypeKind.ALIAS && (def = (ITypeDecl)(typedef = (ITypedefDecl)t.queryInterface(ITypedefDecl.class)).getDefinition().queryInterface(ITypeDecl.class)) != null) {
                    IDispInterfaceDecl dispi;
                    this.aliases.put(def, typedef.getName());
                    if (def.getKind() == TypeKind.DISPATCH && (dispi = (IDispInterfaceDecl)def.queryInterface(IDispInterfaceDecl.class)).isDual()) {
                        IInterfaceDecl custitf = dispi.getVtblInterface();
                        this.aliases.put(custitf, typedef.getName());
                    }
                }
                t.dispose();
            }
        }

        String getSimpleTypeName(ITypeDecl decl) {
            assert (decl.getParent().equals(this.lib));
            String name = this.aliases.containsKey(decl) ? this.aliases.get(decl) : decl.getName();
            GUID guid = this.getGUID(decl);
            if (guid != null && STDOLE_TYPES.contains(guid)) {
                return "Com4jObject";
            }
            return name;
        }

        private GUID getGUID(ITypeDecl decl) {
            IDispInterfaceDecl di = (IDispInterfaceDecl)decl.queryInterface(IDispInterfaceDecl.class);
            if (di != null) {
                return di.getGUID();
            }
            IInterfaceDecl ii = (IInterfaceDecl)decl.queryInterface(IInterfaceDecl.class);
            if (ii != null) {
                return ii.getGUID();
            }
            return null;
        }

        public IndentingWriter createWriter(String fileName) throws IOException {
            return this.pkg.createWriter(this, fileName);
        }

        public void generate() throws IOException {
            ITypeDecl t;
            int i;
            IWTypeLib tlib = this.lib;
            this.generatePackageHtml();
            int len = tlib.count();
            for (i = 0; i < len; ++i) {
                t = tlib.getType(i);
                if (t.getKind() != TypeKind.COCLASS) continue;
                this.generateEventsFrom((ICoClassDecl)t.queryInterface(ICoClassDecl.class));
            }
            for (i = 0; i < len; ++i) {
                t = tlib.getType(i);
                switch (t.getKind()) {
                    case DISPATCH: {
                        this.generate((IDispInterfaceDecl)t.queryInterface(IDispInterfaceDecl.class));
                        break;
                    }
                    case INTERFACE: {
                        new CustomInterfaceGenerator(this, (IInterfaceDecl)t.queryInterface(IInterfaceDecl.class)).generate();
                        break;
                    }
                    case ENUM: {
                        this.generate((IEnumDecl)t.queryInterface(IEnumDecl.class));
                    }
                }
                t.dispose();
            }
        }

        private void generatePackageHtml() throws IOException {
            IndentingWriter o = this.createWriter("package.html");
            o.println("<html><body>");
            o.printf("<h2>%1s</h2>", this.lib.getName());
            o.printf("<p>%1s</p>", this.lib.getHelpString());
            o.println("</html></body>");
            o.close();
        }

        private void generate(IEnumDecl t) throws IOException {
            int len = t.countConstants();
            IConstant[] cons = new IConstant[len];
            for (int i = 0; i < len; ++i) {
                cons[i] = t.getConstant(i);
            }
            boolean needComEnum = false;
            if (Generator.this.alwaysUseComEnums) {
                needComEnum = true;
            } else {
                for (int i = 0; i < len; ++i) {
                    if (cons[i].getValue() == i) continue;
                    needComEnum = true;
                    break;
                }
            }
            String typeName = this.getSimpleTypeName(t);
            IndentingWriter o = this.createWriter(typeName + ".java");
            this.generateHeader(o);
            o.beginJavaDocMode();
            if (t.getHelpString() != null) {
                o.println("<p>");
                o.println(t.getHelpString());
                o.println("</p>");
            }
            o.endJavaDocMode();
            o.printf("public enum %1s ", typeName);
            if (needComEnum) {
                o.print("implements ComEnum ");
            }
            o.println("{");
            o.in();
            for (IConstant con : cons) {
                o.beginJavaDocMode();
                if (con.getHelpString() != null) {
                    o.println("<p>");
                    o.println(con.getHelpString());
                    o.println("</p>");
                }
                o.println("<p>");
                o.println("The value of this constant is " + con.getValue());
                o.println("</p>");
                o.endJavaDocMode();
                o.print(con.getName());
                if (needComEnum) {
                    o.printf("(%1d),", con.getValue());
                } else {
                    o.print(", // ");
                    o.print(con.getValue());
                }
                o.println();
            }
            if (needComEnum) {
                o.println(";");
                o.println();
                o.println("private final int value;");
                o.println(typeName + "(int value) { this.value=value; }");
                o.println("public int comEnumValue() { return value; }");
            }
            o.out();
            o.println("}");
            for (IConstant con : cons) {
                con.dispose();
            }
            o.close();
        }

        private void generate(IDispInterfaceDecl t) throws IOException {
            if (this.eventInterfaces.contains(t)) {
                return;
            }
            if (t.isDual()) {
                new CustomInterfaceGenerator(this, t.getVtblInterface()).generate();
            } else {
                new DispInterfaceGenerator(this, t).generate();
            }
        }

        private void generateEventsFrom(ICoClassDecl co) throws IOException {
            int len = co.countImplementedInterfaces();
            for (int i = 0; i < len; ++i) {
                IDispInterfaceDecl di;
                ITypeDecl it;
                IImplementedInterfaceDecl item = co.getImplementedInterface(i);
                if (!item.isSource() || !this.eventInterfaces.add(it = item.getType()) || (di = (IDispInterfaceDecl)it.queryInterface(IDispInterfaceDecl.class)) == null) continue;
                new EventInterfaceGenerator(this, di).generate();
            }
        }

        void generateHeader(IndentingWriter o) {
            this.generateHeader(o, null);
        }

        void generateHeader(IndentingWriter o, String subPackage) {
            if (!this.pkg.isRoot() || subPackage != null) {
                subPackage = subPackage == null ? "" : '.' + subPackage;
                o.printf("package %1s%2s;", this.pkg.name, subPackage);
                o.println();
                o.println();
            }
            o.println("import com4j.*;");
            o.println();
        }

        public final Generator parent() {
            return Generator.this;
        }
    }

    private final class Package {
        final String name;
        private final Map<String, LibBinder> fileNames = new HashMap<String, LibBinder>();
        final Set<LibBinder> typeLibs = new HashSet<LibBinder>();

        public Package(String name) {
            this.name = name;
        }

        private File getDir() {
            if (this.isRoot()) {
                return new File(".");
            }
            return new File(this.name.replace('.', File.separatorChar));
        }

        public boolean isRoot() {
            return this.name.equals("");
        }

        public IndentingWriter createWriter(LibBinder lib, String fileName) throws IOException {
            LibBinder tli = this.fileNames.get(fileName);
            if (tli != null) {
                Generator.this.el.error(new BindingException(Messages.FILE_CONFLICT.format(fileName, tli.lib.getName(), lib.lib.getName(), this.name)));
            } else {
                this.fileNames.put(fileName, lib);
            }
            return Generator.this.writer.create(new File(this.getDir(), fileName));
        }
    }
}

