/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.EventInterfaceGenerator;
import com4j.tlbimp.Generator;
import com4j.tlbimp.IndentingWriter;
import com4j.tlbimp.InvocableInterfaceGenerator;
import com4j.tlbimp.TypeBinding;
import com4j.tlbimp.def.IDispInterfaceDecl;
import com4j.tlbimp.def.IMethod;
import com4j.tlbimp.def.IProperty;
import com4j.tlbimp.def.IType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DispInterfaceGenerator
extends InvocableInterfaceGenerator<IDispInterfaceDecl> {
    private static final GUID GUID_IDISPATCH = new GUID("{00020400-0000-0000-C000-000000000046}");

    public DispInterfaceGenerator(Generator.LibBinder lib, IDispInterfaceDecl t) {
        super(lib, t);
    }

    @Override
    protected List<String> getBaseTypes() {
        return new ArrayList<String>();
    }

    @Override
    protected GUID getIID() {
        return GUID_IDISPATCH;
    }

    @Override
    protected MethodBinderImpl createMethodBinder(IMethod m) throws BindingException {
        if (EventInterfaceGenerator.isBogusDispatchMethod(m)) {
            return null;
        }
        return new MethodBinderImpl(this.g, m);
    }

    @Override
    protected void generateProperty(IProperty p, IndentingWriter o) throws BindingException {
        TypeBinding tb = TypeBinding.bind(this.g, p.getType(), null);
        String typeString = tb.javaType;
        String propName = p.getName().substring(0, 1).toUpperCase() + p.getName().substring(1);
        o.beginJavaDocMode();
        String help = p.getHelpString();
        if (help != null) {
            o.println("<p>");
            o.println(help);
            o.println("</p>");
        }
        o.println("<p>");
        o.println("Getter method for the COM property \"" + p.getName() + "\"");
        o.println("</p>");
        o.println("@return The COM property " + p.getName() + " as a " + typeString);
        o.endJavaDocMode();
        o.printf("@DISPID(%1d)", p.getDispId());
        o.println();
        o.println("@PropGet");
        o.printf("%s get%s();", typeString, propName);
        o.println();
        o.println();
        o.beginJavaDocMode();
        if (help != null) {
            o.println("<p>");
            o.print(help);
            o.println("</p>");
        }
        o.println("<p>");
        o.println("Setter method for the COM property \"" + p.getName() + "\"");
        o.println("</p>");
        o.println("@param newValue The new value for the COM property " + p.getName() + " as a " + typeString);
        o.endJavaDocMode();
        o.printf("@DISPID(%1d)", p.getDispId());
        o.println();
        o.println("@PropPut");
        o.printf("void set%s(%s newValue);", propName, typeString);
        o.println();
        o.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MethodBinderImpl
    extends InvocableInterfaceGenerator.MethodBinderImpl {
        public MethodBinderImpl(Generator g, IMethod method) throws BindingException {
            super(g, method);
        }

        @Override
        protected IType getReturnTypeBinding() {
            return this.getDispInterfaceReturnType();
        }

        @Override
        protected void annotate(IndentingWriter o) {
            super.annotate(o);
            if (((IDispInterfaceDecl)DispInterfaceGenerator.this.t).isDual()) {
                o.printf("@VTID(%1d)", this.method.getVtableIndex());
                o.println();
            }
            o.printf("@DISPID(%1d)", this.method.getDispId());
            o.println();
            switch (this.method.getKind()) {
                case PROPERTYGET: {
                    o.println("@PropGet");
                    break;
                }
                case PROPERTYPUT: 
                case PROPERTYPUTREF: {
                    o.println("@PropPut");
                }
            }
        }
    }
}

