/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

class CancellableWriter
extends FilterWriter {
    private final StringBuffer buffer = new StringBuffer();
    private boolean marked;

    public void mark() throws IOException {
        if (this.marked) {
            this.commit();
        }
        this.marked = true;
    }

    public void cancel() {
        if (!this.marked) {
            throw new IllegalStateException();
        }
        this.marked = false;
        this.buffer.setLength(0);
    }

    public void commit() throws IOException {
        if (!this.marked) {
            throw new IllegalStateException();
        }
        this.marked = false;
        super.append(this.buffer);
        this.buffer.setLength(0);
    }

    public CancellableWriter(Writer out) {
        super(out);
    }

    public void write(int c) throws IOException {
        if (this.marked) {
            this.buffer.append((char)c);
        } else {
            super.write(c);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.marked) {
            this.buffer.append(cbuf, off, len);
        } else {
            super.write(cbuf, off, len);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.marked) {
            this.buffer.append(str, off, len);
        } else {
            super.write(str, off, len);
        }
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void close() throws IOException {
        if (this.marked) {
            this.commit();
        }
        super.close();
    }
}

