/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.serialization.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import org.jupiter.serialization.io.OutputBuf;

class NioBufOutput
extends ByteBufferOutput {
    protected final OutputBuf outputBuf;

    NioBufOutput(OutputBuf outputBuf, int minWritableBytes, int maxCapacity) {
        this.outputBuf = outputBuf;
        this.maxCapacity = maxCapacity;
        this.niobuffer = outputBuf.nioByteBuffer(minWritableBytes);
        this.capacity = this.niobuffer.remaining();
    }

    protected boolean require(int required) throws KryoException {
        if (this.capacity - this.position >= required) {
            return false;
        }
        if (required > this.maxCapacity) {
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
        }
        this.flush();
        while (this.capacity - this.position < required) {
            if (this.capacity == this.maxCapacity) {
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + required);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = Math.min(this.capacity << 1, this.maxCapacity);
            if (this.capacity >= 0) continue;
            this.capacity = this.maxCapacity;
        }
        this.niobuffer = this.outputBuf.nioByteBuffer(this.capacity - this.position);
        this.capacity = this.niobuffer.limit();
        return true;
    }
}

