/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import org.jupiter.common.concurrent.collection.ConcurrentSet;
import org.jupiter.common.util.internal.InternalThreadLocal;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerType;
import org.jupiter.serialization.io.InputBuf;
import org.jupiter.serialization.io.OutputBuf;
import org.jupiter.serialization.kryo.io.Inputs;
import org.jupiter.serialization.kryo.io.Outputs;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoSerializer
extends Serializer {
    private static ConcurrentSet<Class<?>> useJavaSerializerTypes = new ConcurrentSet();
    private static final InternalThreadLocal<Kryo> kryoThreadLocal;

    public static void setJavaSerializer(Class<?> type) {
        useJavaSerializerTypes.add(type);
    }

    public byte code() {
        return SerializerType.KRYO.value();
    }

    public <T> OutputBuf writeObject(OutputBuf outputBuf, T obj) {
        Output output = Outputs.getOutput(outputBuf);
        Kryo kryo = (Kryo)kryoThreadLocal.get();
        kryo.writeObject(output, obj);
        return outputBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] writeObject(T obj) {
        Output output = Outputs.getOutput();
        Kryo kryo = (Kryo)kryoThreadLocal.get();
        try {
            kryo.writeObject(output, obj);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        finally {
            Outputs.clearOutput(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(InputBuf inputBuf, Class<T> clazz) {
        Input input = Inputs.getInput(inputBuf);
        Kryo kryo = (Kryo)kryoThreadLocal.get();
        try {
            Object object = kryo.readObject(input, clazz);
            return (T)object;
        }
        finally {
            inputBuf.release();
        }
    }

    public <T> T readObject(byte[] bytes, int offset, int length, Class<T> clazz) {
        Input input = Inputs.getInput(bytes, offset, length);
        Kryo kryo = (Kryo)kryoThreadLocal.get();
        return (T)kryo.readObject(input, clazz);
    }

    public String toString() {
        return "kryo:(code=" + this.code() + ")";
    }

    static {
        useJavaSerializerTypes.add(Throwable.class);
        kryoThreadLocal = new InternalThreadLocal<Kryo>(){

            protected Kryo initialValue() throws Exception {
                Kryo kryo = new Kryo();
                for (Class type : useJavaSerializerTypes) {
                    kryo.addDefaultSerializer(type, JavaSerializer.class);
                }
                kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
                kryo.setRegistrationRequired(false);
                kryo.setReferences(false);
                return kryo;
            }
        };
    }
}

