/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestExecutionResult;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class TestExecutionResultConditions {
    private TestExecutionResultConditions() {
    }

    public static Condition<TestExecutionResult> status(TestExecutionResult.Status expectedStatus) {
        return new Condition(FunctionUtils.where(TestExecutionResult::getStatus, Predicate.isEqual(expectedStatus)), "status is %s", new Object[]{expectedStatus});
    }

    @SafeVarargs
    public static Condition<TestExecutionResult> throwable(Condition<Throwable> ... conditions) {
        List<Condition> list = Arrays.stream(conditions).map(TestExecutionResultConditions::throwable).toList();
        return Assertions.allOf(list);
    }

    @SafeVarargs
    public static Condition<Throwable> cause(Condition<Throwable> ... conditions) {
        List<Condition> list = Arrays.stream(conditions).map(TestExecutionResultConditions::cause).toList();
        return Assertions.allOf(list);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    @SafeVarargs
    public static Condition<Throwable> rootCause(Condition<Throwable> ... conditions) {
        List<Condition> list = Arrays.stream(conditions).map(TestExecutionResultConditions::rootCause).toList();
        return Assertions.allOf(list);
    }

    @SafeVarargs
    public static Condition<Throwable> suppressed(int index, Condition<Throwable> ... conditions) {
        List<Condition> list = Arrays.stream(conditions).map(condition -> TestExecutionResultConditions.suppressed(index, (Condition<Throwable>)condition)).toList();
        return Assertions.allOf(list);
    }

    public static Condition<Throwable> instanceOf(Class<? extends Throwable> expectedType) {
        return new Condition(expectedType::isInstance, "instance of %s", new Object[]{expectedType.getName()});
    }

    public static Condition<Throwable> message(String expectedMessage) {
        return new Condition(FunctionUtils.where(Throwable::getMessage, Predicate.isEqual(expectedMessage)), "message is '%s'", new Object[]{expectedMessage});
    }

    public static Condition<Throwable> message(Predicate<String> expectedMessagePredicate) {
        return new Condition(FunctionUtils.where(Throwable::getMessage, expectedMessagePredicate), "message matches predicate", new Object[0]);
    }

    private static Condition<TestExecutionResult> throwable(Condition<? super Throwable> condition) {
        return new Condition(FunctionUtils.where(TestExecutionResult::getThrowable, throwable -> throwable.isPresent() && condition.matches(throwable.get())), "throwable matches %s", new Object[]{condition});
    }

    private static Condition<Throwable> cause(Condition<Throwable> condition) {
        return new Condition(throwable -> condition.matches((Object)throwable.getCause()), "throwable cause matches %s", new Object[]{condition});
    }

    private static Condition<Throwable> rootCause(Condition<Throwable> condition) {
        Predicate<Throwable> predicate = throwable -> {
            Preconditions.notNull((Object)throwable, (String)"Throwable must not be null");
            Preconditions.notNull((Object)throwable.getCause(), (String)"Throwable does not have a cause");
            Throwable rootCause = TestExecutionResultConditions.getRootCause(throwable, new ArrayList<Throwable>());
            return condition.matches((Object)rootCause);
        };
        return new Condition(predicate, "throwable root cause matches %s", new Object[]{condition});
    }

    private static Throwable getRootCause(Throwable throwable, List<Throwable> causeChain) {
        if (causeChain.contains(throwable)) {
            return causeChain.get(causeChain.size() - 1);
        }
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        causeChain.add(throwable);
        return TestExecutionResultConditions.getRootCause(cause, causeChain);
    }

    private static Condition<Throwable> suppressed(int index, Condition<Throwable> condition) {
        return new Condition(throwable -> throwable.getSuppressed().length > index && condition.matches((Object)throwable.getSuppressed()[index]), "suppressed throwable at index %d matches %s", new Object[]{index, condition});
    }
}

