/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.OutputDirectoryCreator;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.junit.platform.testkit.engine.EngineDiscoveryResults;
import org.junit.platform.testkit.engine.EngineExecutionResults;
import org.junit.platform.testkit.engine.ExecutionRecorder;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class EngineTestKit {
    public static Builder engine(String engineId) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.engine(EngineTestKit.loadTestEngine(engineId.strip()));
    }

    public static Builder engine(TestEngine testEngine) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        return new Builder(testEngine);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static EngineDiscoveryResults discover(String engineId, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.discover(EngineTestKit.loadTestEngine(engineId.strip()), discoveryRequest);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static EngineDiscoveryResults discover(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        Preconditions.notNull((Object)discoveryRequest, (String)"EngineDiscoveryRequest must not be null");
        LauncherDiscoveryResult discoveryResult = EngineTestKit.discoverUsingOrchestrator(testEngine, discoveryRequest);
        TestDescriptor engineDescriptor = discoveryResult.getEngineTestDescriptor(testEngine);
        List discoveryIssues = discoveryResult.getDiscoveryIssues(testEngine);
        return new EngineDiscoveryResults(engineDescriptor, discoveryIssues);
    }

    public static EngineExecutionResults execute(String engineId, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.execute(EngineTestKit.loadTestEngine(engineId.strip()), discoveryRequest);
    }

    public static EngineExecutionResults execute(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        Preconditions.notNull((Object)discoveryRequest, (String)"EngineDiscoveryRequest must not be null");
        ExecutionRecorder executionRecorder = new ExecutionRecorder();
        EngineTestKit.executeUsingLauncherOrchestration(testEngine, discoveryRequest, executionRecorder, CancellationToken.disabled());
        return executionRecorder.getExecutionResults();
    }

    private static void executeUsingLauncherOrchestration(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest, EngineExecutionListener listener, CancellationToken cancellationToken) {
        LauncherDiscoveryResult discoveryResult = EngineTestKit.discoverUsingOrchestrator(testEngine, discoveryRequest);
        TestDescriptor engineTestDescriptor = discoveryResult.getEngineTestDescriptor(testEngine);
        Preconditions.notNull((Object)engineTestDescriptor, (String)"TestEngine did not yield a TestDescriptor");
        EngineTestKit.withRequestLevelStore(store -> new EngineExecutionOrchestrator().execute(discoveryResult, listener, store, cancellationToken));
    }

    private static void withRequestLevelStore(Consumer<NamespacedHierarchicalStore<Namespace>> action) {
        try (NamespacedHierarchicalStore<Namespace> sessionLevelStore = EngineTestKit.newStore(null);
             NamespacedHierarchicalStore<Namespace> requestLevelStore = EngineTestKit.newStore(sessionLevelStore);){
            action.accept(requestLevelStore);
        }
    }

    private static NamespacedHierarchicalStore<Namespace> newStore(@Nullable NamespacedHierarchicalStore<Namespace> parentStore) {
        return new NamespacedHierarchicalStore(parentStore, NamespacedHierarchicalStore.CloseAction.closeAutoCloseables());
    }

    private static LauncherDiscoveryResult discoverUsingOrchestrator(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        return new EngineDiscoveryOrchestrator(Collections.singleton(testEngine), Collections.emptySet()).discover(discoveryRequest);
    }

    private static TestEngine loadTestEngine(String engineId) {
        Iterable testEngines = new ServiceLoaderTestEngineRegistry().loadTestEngines();
        return CollectionUtils.toStream((Object)testEngines).filter(engine -> engineId.equals(engine.getId())).findFirst().orElseThrow(() -> new PreconditionViolationException("Failed to load TestEngine with ID [%s]".formatted(engineId)));
    }

    private EngineTestKit() {
    }

    public static final class Builder {
        private final LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().enableImplicitConfigurationParameters(false).outputDirectoryCreator(DisabledOutputDirectoryCreator.INSTANCE);
        private final TestEngine testEngine;
        private @Nullable CancellationToken cancellationToken;

        private Builder(TestEngine testEngine) {
            this.testEngine = testEngine;
        }

        public Builder selectors(DiscoverySelector ... selectors) {
            this.requestBuilder.selectors(selectors);
            return this;
        }

        @API(status=API.Status.MAINTAINED, since="6.0")
        public Builder selectors(List<? extends DiscoverySelector> selectors) {
            this.requestBuilder.selectors(selectors);
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder filters(Filter<?> ... filters) {
            this.requestBuilder.filters(filters);
            return this;
        }

        public Builder configurationParameter(String key, String value) {
            this.requestBuilder.configurationParameter(key, value);
            return this;
        }

        public Builder configurationParameters(Map<String, String> configurationParameters) {
            this.requestBuilder.configurationParameters(configurationParameters);
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder enableImplicitConfigurationParameters(boolean enabled) {
            this.requestBuilder.enableImplicitConfigurationParameters(enabled);
            return this;
        }

        @Deprecated(since="6.0", forRemoval=true)
        @API(status=API.Status.DEPRECATED, since="6.0")
        public Builder outputDirectoryProvider(OutputDirectoryProvider outputDirectoryProvider) {
            return this.outputDirectoryCreator((OutputDirectoryCreator)outputDirectoryProvider);
        }

        @API(status=API.Status.MAINTAINED, since="6.0")
        public Builder outputDirectoryCreator(OutputDirectoryCreator outputDirectoryCreator) {
            this.requestBuilder.outputDirectoryCreator(outputDirectoryCreator);
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="6.0")
        public Builder cancellationToken(CancellationToken cancellationToken) {
            this.cancellationToken = (CancellationToken)Preconditions.notNull((Object)cancellationToken, (String)"cancellationToken must not be null");
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="6.0")
        public EngineDiscoveryResults discover() {
            LauncherDiscoveryRequest request = this.requestBuilder.build();
            return EngineTestKit.discover(this.testEngine, request);
        }

        public EngineExecutionResults execute() {
            LauncherDiscoveryRequest request = this.requestBuilder.build();
            ExecutionRecorder executionRecorder = new ExecutionRecorder();
            EngineTestKit.executeUsingLauncherOrchestration(this.testEngine, request, executionRecorder, Objects.requireNonNullElseGet(this.cancellationToken, CancellationToken::disabled));
            return executionRecorder.getExecutionResults();
        }

        private static class DisabledOutputDirectoryCreator
        implements OutputDirectoryCreator {
            private static final OutputDirectoryCreator INSTANCE = new DisabledOutputDirectoryCreator();
            private static final String FAILURE_MESSAGE = "Writing outputs is disabled by default when using EngineTestKit. To enable, configure a custom OutputDirectoryCreator via EngineTestKit#outputDirectoryCreator.";

            private DisabledOutputDirectoryCreator() {
            }

            public Path getRootDirectory() {
                throw new JUnitException(FAILURE_MESSAGE);
            }

            public Path createOutputDirectory(TestDescriptor testDescriptor) {
                throw new JUnitException(FAILURE_MESSAGE);
            }
        }
    }
}

