/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

class Assertions {
    Assertions() {
    }

    static void assertAll(String heading, Stream<Executable> executables) {
        Preconditions.notNull(executables, (String)"executables stream must not be null");
        List<Throwable> failures = executables.map(executable -> {
            Preconditions.notNull((Object)executable, (String)"individual executables must not be null");
            try {
                executable.execute();
                return null;
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
                return t;
            }
        }).filter(Objects::nonNull).toList();
        if (!failures.isEmpty()) {
            MultipleFailuresError multipleFailuresError = new MultipleFailuresError(heading, failures);
            failures.forEach(arg_0 -> multipleFailuresError.addSuppressed(arg_0));
            throw multipleFailuresError;
        }
    }

    static void assertEquals(long expected, long actual, String message) {
        if (expected != actual) {
            Assertions.failNotEqual(expected, actual, message);
        }
    }

    private static void failNotEqual(long expected, long actual, String message) {
        Assertions.fail(Assertions.format(expected, actual, message), expected, actual);
    }

    private static void fail(String message, Object expected, Object actual) {
        throw new AssertionFailedError(message, expected, actual);
    }

    private static String format(long expected, long actual, String message) {
        return Assertions.buildPrefix(message) + Assertions.formatValues(expected, actual);
    }

    private static String buildPrefix(String message) {
        return StringUtils.isNotBlank((String)message) ? message + " ==> " : "";
    }

    private static String formatValues(long expected, long actual) {
        return "expected: <%d> but was: <%d>".formatted(expected, actual);
    }

    @FunctionalInterface
    static interface Executable {
        public void execute() throws Throwable;
    }
}

