/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.testkit.engine.EngineExecutionResults;
import org.junit.platform.testkit.engine.ExecutionRecorder;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class EngineTestKit {
    private static final Logger logger = LoggerFactory.getLogger(EngineTestKit.class);

    public static Builder engine(String engineId) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.engine(EngineTestKit.loadTestEngine(engineId.trim()));
    }

    public static Builder engine(TestEngine testEngine) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        return new Builder(testEngine);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7")
    public static EngineExecutionResults execute(String engineId, EngineDiscoveryRequest discoveryRequest) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.execute(EngineTestKit.loadTestEngine(engineId.trim()), discoveryRequest);
    }

    public static EngineExecutionResults execute(String engineId, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.execute(EngineTestKit.loadTestEngine(engineId.trim()), discoveryRequest);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7")
    public static EngineExecutionResults execute(TestEngine testEngine, EngineDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        Preconditions.notNull((Object)discoveryRequest, (String)"EngineDiscoveryRequest must not be null");
        ExecutionRecorder executionRecorder = new ExecutionRecorder();
        EngineTestKit.executeDirectly(testEngine, discoveryRequest, executionRecorder);
        return executionRecorder.getExecutionResults();
    }

    public static EngineExecutionResults execute(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        Preconditions.notNull((Object)discoveryRequest, (String)"EngineDiscoveryRequest must not be null");
        ExecutionRecorder executionRecorder = new ExecutionRecorder();
        EngineTestKit.executeUsingLauncherOrchestration(testEngine, discoveryRequest, executionRecorder);
        return executionRecorder.getExecutionResults();
    }

    private static void executeDirectly(TestEngine testEngine, EngineDiscoveryRequest discoveryRequest, EngineExecutionListener listener) {
        UniqueId engineUniqueId = UniqueId.forEngine((String)testEngine.getId());
        TestDescriptor engineTestDescriptor = testEngine.discover(discoveryRequest, engineUniqueId);
        ExecutionRequest request = new ExecutionRequest(engineTestDescriptor, listener, discoveryRequest.getConfigurationParameters());
        testEngine.execute(request);
    }

    private static void executeUsingLauncherOrchestration(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest, EngineExecutionListener listener) {
        LauncherDiscoveryResult discoveryResult = new EngineDiscoveryOrchestrator(Collections.singleton(testEngine), Collections.emptySet()).discover(discoveryRequest, "testing");
        TestDescriptor engineTestDescriptor = discoveryResult.getEngineTestDescriptor(testEngine);
        Preconditions.notNull((Object)engineTestDescriptor, (String)"TestEngine did not yield a TestDescriptor");
        new EngineExecutionOrchestrator().execute(discoveryResult, listener);
    }

    private static TestEngine loadTestEngine(String engineId) {
        return StreamSupport.stream(EngineTestKit.loadTestEngines().spliterator(), false).filter(engine -> engineId.equals(engine.getId())).findFirst().orElseThrow(() -> new PreconditionViolationException(String.format("Failed to load TestEngine with ID [%s]", engineId)));
    }

    private static Iterable<TestEngine> loadTestEngines() {
        ClassLoader defaultClassLoader = ClassLoaderUtils.getDefaultClassLoader();
        ServiceLoader<TestEngine> testEngines = ServiceLoader.load(TestEngine.class, defaultClassLoader);
        logger.config(() -> EngineTestKit.createDiscoveredTestEnginesMessage(testEngines));
        return testEngines;
    }

    private static String createDiscoveredTestEnginesMessage(Iterable<TestEngine> testEngines) {
        List details = CollectionUtils.toStream(testEngines).map(engine -> String.format("%s (%s)", engine.getId(), String.join((CharSequence)", ", EngineTestKit.computeAttributes(engine)))).collect(Collectors.toList());
        return details.isEmpty() ? "No TestEngine implementation discovered." : "Discovered TestEngines with IDs: [" + String.join((CharSequence)", ", details) + "]";
    }

    private static List<String> computeAttributes(TestEngine engine) {
        ArrayList<String> attributes = new ArrayList<String>(4);
        engine.getGroupId().ifPresent(groupId -> attributes.add("group ID: " + groupId));
        engine.getArtifactId().ifPresent(artifactId -> attributes.add("artifact ID: " + artifactId));
        engine.getVersion().ifPresent(version -> attributes.add("version: " + version));
        ClassLoaderUtils.getLocation((Object)engine).ifPresent(location -> attributes.add("location: " + location));
        return attributes;
    }

    private EngineTestKit() {
    }

    public static final class Builder {
        private final LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().enableImplicitConfigurationParameters(false);
        private final TestEngine testEngine;

        private Builder(TestEngine testEngine) {
            this.testEngine = testEngine;
        }

        public Builder selectors(DiscoverySelector ... selectors) {
            this.requestBuilder.selectors(selectors);
            return this;
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.7")
        public Builder filters(DiscoveryFilter<?> ... filters) {
            this.requestBuilder.filters(filters);
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.7")
        public Builder filters(Filter<?> ... filters) {
            this.requestBuilder.filters(filters);
            return this;
        }

        public Builder configurationParameter(String key, String value) {
            this.requestBuilder.configurationParameter(key, value);
            return this;
        }

        public Builder configurationParameters(Map<String, String> configurationParameters) {
            this.requestBuilder.configurationParameters(configurationParameters);
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.7")
        public Builder enableImplicitConfigurationParameters(boolean enabled) {
            this.requestBuilder.enableImplicitConfigurationParameters(enabled);
            return this;
        }

        public EngineExecutionResults execute() {
            LauncherDiscoveryRequest request = this.requestBuilder.build();
            ExecutionRecorder executionRecorder = new ExecutionRecorder();
            EngineTestKit.executeUsingLauncherOrchestration(this.testEngine, request, executionRecorder);
            return executionRecorder.getExecutionResults();
        }
    }
}

