/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.assertj.core.api.Condition;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.engine.TestExecutionResult;

@API(status=API.Status.EXPERIMENTAL, since="1.4")
public final class TestExecutionResultConditions {
    private TestExecutionResultConditions() {
    }

    public static Condition<TestExecutionResult> status(TestExecutionResult.Status expectedStatus) {
        return new Condition(FunctionUtils.where(TestExecutionResult::getStatus, Predicate.isEqual(expectedStatus)), "status is %s", new Object[]{expectedStatus});
    }

    public static Condition<TestExecutionResult> throwable(Condition<? super Throwable> condition) {
        return new Condition(FunctionUtils.where(TestExecutionResult::getThrowable, throwable -> throwable.isPresent() && condition.matches(throwable.get())), "throwable matches %s", new Object[]{condition});
    }

    public static Condition<Throwable> cause(Condition<Throwable> condition) {
        return new Condition(throwable -> condition.matches((Object)throwable.getCause()), "throwable cause matches %s", new Object[]{condition});
    }

    public static Condition<Throwable> suppressed(int index, Condition<Throwable> condition) {
        return new Condition(throwable -> throwable.getSuppressed().length > index && condition.matches((Object)throwable.getSuppressed()[index]), "suppressed throwable at index %d matches %s", new Object[]{index, condition});
    }

    public static Condition<Throwable> instanceOf(Class<? extends Throwable> expectedType) {
        return new Condition(expectedType::isInstance, "instance of %s", new Object[]{expectedType.getName()});
    }

    public static Condition<Throwable> message(String expectedMessage) {
        return new Condition(FunctionUtils.where(Throwable::getMessage, Predicate.isEqual(expectedMessage)), "message is '%s'", new Object[]{expectedMessage});
    }

    public static Condition<Throwable> message(Predicate<String> expectedMessagePredicate) {
        return new Condition(FunctionUtils.where(Throwable::getMessage, expectedMessagePredicate), "message matches predicate", new Object[0]);
    }
}

