/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.testkit.engine.Assertions;
import org.junit.platform.testkit.engine.Events;

@API(status=API.Status.EXPERIMENTAL, since="1.4")
public class EventStatistics {
    private final List<Assertions.Executable> executables = new ArrayList<Assertions.Executable>();
    private final Events events;

    EventStatistics(Events events, String category) {
        this.events = events;
    }

    void assertAll() {
        Assertions.assertAll(this.events.getCategory() + " Event Statistics", this.executables.stream());
    }

    public EventStatistics skipped(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.skipped().count(), "skipped"));
        return this;
    }

    public EventStatistics started(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.started().count(), "started"));
        return this;
    }

    public EventStatistics finished(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.finished().count(), "finished"));
        return this;
    }

    public EventStatistics aborted(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.aborted().count(), "aborted"));
        return this;
    }

    public EventStatistics succeeded(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.succeeded().count(), "succeeded"));
        return this;
    }

    public EventStatistics failed(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.failed().count(), "failed"));
        return this;
    }

    public EventStatistics reportingEntryPublished(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.reportingEntryPublished().count(), "reporting entry published"));
        return this;
    }

    public EventStatistics dynamicallyRegistered(long expected) {
        this.executables.add(() -> Assertions.assertEquals(expected, this.events.dynamicallyRegistered().count(), "dynamically registered"));
        return this;
    }
}

