/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.JoinDescription;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.testkit.engine.Event;
import org.junit.platform.testkit.engine.EventType;
import org.junit.platform.testkit.engine.TestExecutionResultConditions;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class EventConditions {
    private EventConditions() {
    }

    @SafeVarargs
    public static Condition<Event> event(Condition<? super Event> ... conditions) {
        return Assertions.allOf(conditions);
    }

    public static Condition<Event> engine() {
        return new Condition(Event.byTestDescriptor(EngineDescriptor.class::isInstance), "is an engine", new Object[0]);
    }

    public static Condition<Event> test(String uniqueIdSubstring) {
        return EventConditions.test(EventConditions.uniqueIdSubstring(uniqueIdSubstring));
    }

    public static Condition<Event> test(String uniqueIdSubstring, String displayName) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.test(), EventConditions.uniqueIdSubstring(uniqueIdSubstring), EventConditions.displayName(displayName)});
    }

    @API(status=API.Status.MAINTAINED, since="1.8")
    public static Condition<Event> test(Condition<Event> condition) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.test(), condition});
    }

    public static Condition<Event> test() {
        return new Condition(Event.byTestDescriptor(TestDescriptor::isTest), "is a test", new Object[0]);
    }

    public static Condition<Event> container(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        return EventConditions.container(clazz.getName());
    }

    public static Condition<Event> container(String uniqueIdSubstring) {
        return EventConditions.container(EventConditions.uniqueIdSubstring(uniqueIdSubstring));
    }

    public static Condition<Event> container(Condition<Event> condition) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.container(), condition});
    }

    public static Condition<Event> container() {
        return new Condition(Event.byTestDescriptor(TestDescriptor::isContainer), "is a container", new Object[0]);
    }

    @API(status=API.Status.MAINTAINED, since="1.8")
    public static Condition<Event> nestedContainer(Class<?> clazz, Condition<Event> condition) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.nestedContainer(clazz), condition});
    }

    public static Condition<Event> nestedContainer(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Preconditions.notNull(clazz.getEnclosingClass(), () -> clazz.getName() + " must be a nested class");
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> current = clazz; current != null; current = current.getEnclosingClass()) {
            classNames.add(0, current.getSimpleName());
        }
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.container(), EventConditions.uniqueIdSubstrings(classNames)});
    }

    public static Condition<Event> dynamicTestRegistered(String uniqueIdSubstring) {
        return EventConditions.dynamicTestRegistered(EventConditions.uniqueIdSubstring(uniqueIdSubstring));
    }

    public static Condition<Event> dynamicTestRegistered(Condition<Event> condition) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.type(EventType.DYNAMIC_TEST_REGISTERED), condition});
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Condition<Event> uniqueId(String uniqueId) {
        return EventConditions.uniqueId(UniqueId.parse((String)uniqueId));
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Condition<Event> uniqueId(UniqueId uniqueId) {
        return EventConditions.uniqueId((Condition<? super UniqueId>)new Condition(Predicate.isEqual(uniqueId), "equal to '%s'", new Object[]{uniqueId}));
    }

    public static Condition<Event> uniqueIdSubstring(String uniqueIdSubstring) {
        Predicate<UniqueId.Segment> predicate = segment -> {
            String text = segment.getType() + ":" + segment.getValue();
            return text.contains(uniqueIdSubstring);
        };
        return EventConditions.uniqueId((Condition<? super UniqueId>)new Condition(uniqueId -> uniqueId.getSegments().stream().anyMatch(predicate), "substring '%s'", new Object[]{uniqueIdSubstring}));
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Condition<Event> uniqueId(Condition<? super UniqueId> condition) {
        return new Condition(Event.byTestDescriptor(FunctionUtils.where(TestDescriptor::getUniqueId, arg_0 -> condition.matches(arg_0))), "descriptor with uniqueId %s", new Object[]{condition.description().value()});
    }

    public static Condition<Event> uniqueIdSubstrings(String ... uniqueIdSubstrings) {
        return EventConditions.uniqueIdSubstrings(Arrays.asList(uniqueIdSubstrings));
    }

    public static Condition<Event> uniqueIdSubstrings(List<String> uniqueIdSubstrings) {
        List conditions = uniqueIdSubstrings.stream().map(EventConditions::uniqueIdSubstring).collect(Collectors.toList());
        List descriptions = conditions.stream().map(Condition::description).collect(Collectors.toList());
        return Assertions.allOf(conditions).describedAs((Description)new JoinDescription("all of :[", "]", descriptions));
    }

    public static Condition<Event> displayName(String displayName) {
        return new Condition(Event.byTestDescriptor(FunctionUtils.where(TestDescriptor::getDisplayName, Predicate.isEqual(displayName))), "descriptor with display name '%s'", new Object[]{displayName});
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Condition<Event> legacyReportingName(String legacyReportingName) {
        return new Condition(Event.byTestDescriptor(FunctionUtils.where(TestDescriptor::getLegacyReportingName, Predicate.isEqual(legacyReportingName))), "descriptor with legacy reporting name '%s'", new Object[]{legacyReportingName});
    }

    public static Condition<Event> skippedWithReason(String expectedReason) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.type(EventType.SKIPPED), EventConditions.reason(expectedReason)});
    }

    public static Condition<Event> skippedWithReason(Predicate<String> predicate) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.type(EventType.SKIPPED), EventConditions.reason(predicate)});
    }

    public static Condition<Event> started() {
        return EventConditions.type(EventType.STARTED);
    }

    @SafeVarargs
    public static Condition<Event> abortedWithReason(Condition<Throwable> ... conditions) {
        return EventConditions.finishedWithCause(TestExecutionResult.Status.ABORTED, conditions);
    }

    @SafeVarargs
    public static Condition<Event> finishedWithFailure(Condition<Throwable> ... conditions) {
        return EventConditions.finishedWithCause(TestExecutionResult.Status.FAILED, conditions);
    }

    private static Condition<Event> finishedWithCause(TestExecutionResult.Status expectedStatus, Condition<Throwable> ... conditions) {
        List<Condition> list = Arrays.asList(TestExecutionResultConditions.status(expectedStatus), TestExecutionResultConditions.throwable(conditions));
        return EventConditions.finished((Condition<TestExecutionResult>)Assertions.allOf(list));
    }

    public static Condition<Event> finishedWithFailure() {
        return EventConditions.finished(TestExecutionResultConditions.status(TestExecutionResult.Status.FAILED));
    }

    public static Condition<Event> finishedSuccessfully() {
        return EventConditions.finished(TestExecutionResultConditions.status(TestExecutionResult.Status.SUCCESSFUL));
    }

    public static Condition<Event> finished(Condition<TestExecutionResult> resultCondition) {
        return Assertions.allOf((Condition[])new Condition[]{EventConditions.type(EventType.FINISHED), EventConditions.result(resultCondition)});
    }

    public static Condition<Event> type(EventType expectedType) {
        return new Condition(Event.byType(expectedType), "type is %s", new Object[]{expectedType});
    }

    public static Condition<Event> result(Condition<TestExecutionResult> condition) {
        return new Condition(Event.byPayload(TestExecutionResult.class, arg_0 -> condition.matches(arg_0)), "event with result where %s", new Object[]{condition});
    }

    public static Condition<Event> reason(String expectedReason) {
        return new Condition(Event.byPayload(String.class, Predicate.isEqual(expectedReason)), "event with reason '%s'", new Object[]{expectedReason});
    }

    public static Condition<Event> reason(Predicate<String> predicate) {
        return new Condition(Event.byPayload(String.class, predicate), "event with custom reason predicate", new Object[0]);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static Condition<Event> reportEntry(Map<String, String> keyValuePairs) {
        return new Condition(Event.byPayload(ReportEntry.class, it -> it.getKeyValuePairs().equals(keyValuePairs)), "event for report entry with key-value pairs %s", new Object[]{keyValuePairs});
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Condition<Event> fileEntry(Predicate<FileEntry> predicate) {
        return new Condition(Event.byPayload(FileEntry.class, predicate), "event for file entry with custom predicate", new Object[0]);
    }
}

