/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;

@API(status=API.Status.EXPERIMENTAL, since="1.13")
public class EngineDiscoveryResults {
    private final TestDescriptor engineDescriptor;
    private final List<DiscoveryIssue> discoveryIssues;

    EngineDiscoveryResults(TestDescriptor engineDescriptor, List<DiscoveryIssue> discoveryIssues) {
        this.engineDescriptor = (TestDescriptor)Preconditions.notNull((Object)engineDescriptor, (String)"Engine descriptor must not be null");
        this.discoveryIssues = Collections.unmodifiableList((List)Preconditions.notNull(discoveryIssues, (String)"Discovery issues list must not be null"));
        Preconditions.containsNoNullElements(discoveryIssues, (String)"Discovery issues list must not contain null elements");
    }

    public TestDescriptor getEngineDescriptor() {
        return this.engineDescriptor;
    }

    public List<DiscoveryIssue> getDiscoveryIssues() {
        return this.discoveryIssues;
    }
}

