/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.time.Instant;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.testkit.engine.EventType;

@API(status=API.Status.MAINTAINED, since="1.7")
public class Event {
    private final Instant timestamp = Instant.now();
    private final EventType type;
    private final TestDescriptor testDescriptor;
    private final Object payload;

    public static Event reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        Preconditions.notNull((Object)entry, (String)"ReportEntry must not be null");
        return new Event(EventType.REPORTING_ENTRY_PUBLISHED, testDescriptor, entry);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.12")
    public static Event fileEntryPublished(TestDescriptor testDescriptor, FileEntry file) {
        Preconditions.notNull((Object)file, (String)"FileEntry must not be null");
        return new Event(EventType.FILE_ENTRY_PUBLISHED, testDescriptor, file);
    }

    public static Event dynamicTestRegistered(TestDescriptor testDescriptor) {
        return new Event(EventType.DYNAMIC_TEST_REGISTERED, testDescriptor, null);
    }

    public static Event executionSkipped(TestDescriptor testDescriptor, String reason) {
        return new Event(EventType.SKIPPED, testDescriptor, reason);
    }

    public static Event executionStarted(TestDescriptor testDescriptor) {
        return new Event(EventType.STARTED, testDescriptor, null);
    }

    public static Event executionFinished(TestDescriptor testDescriptor, TestExecutionResult result) {
        Preconditions.notNull((Object)result, (String)"Event of type FINISHED cannot have a null TestExecutionResult");
        return new Event(EventType.FINISHED, testDescriptor, result);
    }

    public static <T> Predicate<Event> byPayload(Class<T> payloadType, Predicate<? super T> payloadPredicate) {
        return event -> event.getPayload(payloadType).filter(payloadPredicate).isPresent();
    }

    public static Predicate<Event> byType(EventType type) {
        return event -> event.type.equals((Object)type);
    }

    public static Predicate<Event> byTestDescriptor(Predicate<? super TestDescriptor> testDescriptorPredicate) {
        return FunctionUtils.where(Event::getTestDescriptor, testDescriptorPredicate);
    }

    private Event(EventType type, TestDescriptor testDescriptor, Object payload) {
        this.type = (EventType)((Object)Preconditions.notNull((Object)((Object)type), (String)"EventType must not be null"));
        this.testDescriptor = (TestDescriptor)Preconditions.notNull((Object)testDescriptor, (String)"TestDescriptor must not be null");
        this.payload = payload;
    }

    public EventType getType() {
        return this.type;
    }

    public TestDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<Object> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    public <T> Optional<T> getPayload(Class<T> payloadType) {
        Preconditions.notNull(payloadType, (String)"Payload type must not be null");
        return this.getPayload().filter(payloadType::isInstance).map(payloadType::cast);
    }

    public <T> T getRequiredPayload(Class<T> payloadType) throws IllegalArgumentException {
        return this.getPayload(payloadType).orElseThrow(() -> new IllegalArgumentException("Event does not contain a payload of type " + payloadType.getName()));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("testDescriptor", (Object)this.testDescriptor).append("timestamp", (Object)this.timestamp).append("payload", this.payload).toString();
    }
}

