/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.surefire.provider;

import java.util.Optional;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

final class RunListenerAdapter
implements TestExecutionListener {
    private final Class<?> testClass;
    private final RunListener runListener;
    private Optional<TestPlan> testPlan = Optional.empty();

    public RunListenerAdapter(Class<?> testClass, RunListener runListener) {
        this.testClass = testClass;
        this.runListener = runListener;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = Optional.of(testPlan);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = Optional.empty();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.runListener.testStarting((ReportEntry)this.createReportEntry(testIdentifier));
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        String source = this.sourceLegacyReportingName(testIdentifier);
        this.runListener.testSkipped((ReportEntry)SimpleReportEntry.ignored((String)source, (String)testIdentifier.getLegacyReportingName(), (String)reason));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            this.runListener.testAssumptionFailure((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult));
        } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportFailedTest(testIdentifier, testExecutionResult);
        } else if (testIdentifier.isTest()) {
            this.runListener.testSucceeded((ReportEntry)this.createReportEntry(testIdentifier));
        }
    }

    private void reportFailedTest(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        SimpleReportEntry reportEntry = this.createReportEntry(testIdentifier, testExecutionResult);
        if (testExecutionResult.getThrowable().filter(AssertionError.class::isInstance).isPresent()) {
            this.runListener.testFailed((ReportEntry)reportEntry);
        } else {
            this.runListener.testError((ReportEntry)reportEntry);
        }
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier) {
        return this.createReportEntry(testIdentifier, (StackTraceWriter)null);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        return this.createReportEntry(testIdentifier, this.getStackTraceWriter(testIdentifier, testExecutionResult));
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, StackTraceWriter stackTraceWriter) {
        String source = this.sourceLegacyReportingName(testIdentifier);
        String name = testIdentifier.getLegacyReportingName();
        return SimpleReportEntry.withException((String)source, (String)name, (StackTraceWriter)stackTraceWriter);
    }

    private String sourceLegacyReportingName(TestIdentifier testIdentifier) {
        return this.testPlan.flatMap(plan -> plan.getParent(testIdentifier)).map(TestIdentifier::getLegacyReportingName).orElse("<unrooted>");
    }

    private StackTraceWriter getStackTraceWriter(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Optional throwable = testExecutionResult.getThrowable();
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            return this.getStackTraceWriter(testIdentifier, (Throwable)throwable.orElse(null));
        }
        return throwable.map(t -> this.getStackTraceWriter(testIdentifier, (Throwable)t)).orElse(null);
    }

    private StackTraceWriter getStackTraceWriter(TestIdentifier testIdentifier, Throwable throwable) {
        String className = this.getClassName(testIdentifier);
        String methodName = this.getMethodName(testIdentifier).orElse("");
        return new PojoStackTraceWriter(className, methodName, throwable);
    }

    private String getClassName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof ClassSource) {
            return ((ClassSource)testSource).getJavaClass().getName();
        }
        if (testSource instanceof MethodSource) {
            return ((MethodSource)testSource).getClassName();
        }
        return this.testPlan.flatMap(plan -> plan.getParent(testIdentifier)).map(this::getClassName).orElseGet(this.testClass::getName);
    }

    private Optional<String> getMethodName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof MethodSource) {
            return Optional.of(((MethodSource)testSource).getMethodName());
        }
        return Optional.empty();
    }
}

