/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FilePosition;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UriSelector;

class AdditionalDiscoverySelectors {
    static List<UriSelector> selectUris(String ... uris) {
        Preconditions.notNull((Object)uris, (String)"URI list must not be null");
        Preconditions.containsNoNullElements((Object[])uris, (String)"Individual URIs must not be null");
        return AdditionalDiscoverySelectors.uniqueStreamOf(uris).filter(StringUtils::isNotBlank).map(DiscoverySelectors::selectUri).toList();
    }

    static List<DirectorySelector> selectDirectories(String ... paths) {
        Preconditions.notNull((Object)paths, (String)"Directory paths must not be null");
        Preconditions.containsNoNullElements((Object[])paths, (String)"Individual directory paths must not be null");
        return AdditionalDiscoverySelectors.uniqueStreamOf(paths).filter(StringUtils::isNotBlank).map(DiscoverySelectors::selectDirectory).toList();
    }

    static List<PackageSelector> selectPackages(String ... packageNames) {
        Preconditions.notNull((Object)packageNames, (String)"Package names must not be null");
        Preconditions.containsNoNullElements((Object[])packageNames, (String)"Individual package names must not be null");
        return AdditionalDiscoverySelectors.uniqueStreamOf(packageNames).map(DiscoverySelectors::selectPackage).toList();
    }

    static Stream<ClassSelector> selectClasses(Class<?> ... classes) {
        Preconditions.notNull(classes, (String)"classes must not be null");
        Preconditions.containsNoNullElements((Object[])classes, (String)"Individual classes must not be null");
        return AdditionalDiscoverySelectors.uniqueStreamOf(classes).map(DiscoverySelectors::selectClass);
    }

    static Stream<ClassSelector> selectClasses(String ... classNames) {
        Preconditions.notNull((Object)classNames, (String)"classNames must not be null");
        Preconditions.containsNoNullElements((Object[])classNames, (String)"Individual class names must not be null");
        return AdditionalDiscoverySelectors.uniqueStreamOf(classNames).map(DiscoverySelectors::selectClass);
    }

    static List<ModuleSelector> selectModules(String ... moduleNames) {
        Preconditions.notNull((Object)moduleNames, (String)"Module names must not be null");
        Preconditions.containsNoNullElements((Object[])moduleNames, (String)"Individual module names must not be null");
        return DiscoverySelectors.selectModules(AdditionalDiscoverySelectors.uniqueStreamOf(moduleNames).collect(Collectors.toSet()));
    }

    static FileSelector selectFile(String path, int line, int column) {
        Preconditions.notBlank((String)path, (String)"File path must not be null or blank");
        if (line <= 0) {
            return DiscoverySelectors.selectFile((String)path);
        }
        if (column <= 0) {
            return DiscoverySelectors.selectFile((String)path, (FilePosition)FilePosition.from((int)line));
        }
        return DiscoverySelectors.selectFile((String)path, (FilePosition)FilePosition.from((int)line, (int)column));
    }

    static ClasspathResourceSelector selectClasspathResource(String classpathResourceName, int line, int column) {
        Preconditions.notBlank((String)classpathResourceName, (String)"Classpath resource name must not be null or blank");
        if (line <= 0) {
            return DiscoverySelectors.selectClasspathResource((String)classpathResourceName);
        }
        if (column <= 0) {
            return DiscoverySelectors.selectClasspathResource((String)classpathResourceName, (FilePosition)FilePosition.from((int)line));
        }
        return DiscoverySelectors.selectClasspathResource((String)classpathResourceName, (FilePosition)FilePosition.from((int)line, (int)column));
    }

    static List<? extends DiscoverySelector> parseIdentifiers(String[] identifiers) {
        return DiscoverySelectors.parseAll((String[])identifiers).toList();
    }

    private static <T> Stream<T> uniqueStreamOf(T[] elements) {
        return Arrays.stream(elements).distinct();
    }

    private AdditionalDiscoverySelectors() {
    }
}

