/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.platform.suite.engine.IsSuiteClass;
import org.junit.platform.suite.engine.SuiteEngineDescriptor;
import org.junit.platform.suite.engine.SuiteTestDescriptor;

final class ClassSelectorResolver
implements SelectorResolver {
    private final IsSuiteClass isSuiteClass;
    private final Predicate<String> classNameFilter;
    private final SuiteEngineDescriptor suiteEngineDescriptor;
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryProvider outputDirectoryProvider;
    private final EngineDiscoveryListener discoveryListener;
    private final DiscoveryIssueReporter issueReporter;

    ClassSelectorResolver(Predicate<String> classNameFilter, SuiteEngineDescriptor suiteEngineDescriptor, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider, EngineDiscoveryListener discoveryListener, DiscoveryIssueReporter issueReporter) {
        this.isSuiteClass = new IsSuiteClass(issueReporter);
        this.classNameFilter = classNameFilter;
        this.suiteEngineDescriptor = suiteEngineDescriptor;
        this.configurationParameters = configurationParameters;
        this.outputDirectoryProvider = outputDirectoryProvider;
        this.discoveryListener = discoveryListener;
        this.issueReporter = issueReporter;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class testClass = selector.getJavaClass();
        if (this.isSuiteClass.test(testClass) && this.classNameFilter.test(testClass.getName())) {
            Optional<SuiteTestDescriptor> suiteWithDiscoveryRequest = context.addToParent(parent -> this.newSuiteDescriptor(testClass, (TestDescriptor)parent)).map(suite -> suite.addDiscoveryRequestFrom(testClass));
            return ClassSelectorResolver.toResolution(suiteWithDiscoveryRequest);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId engineId = this.suiteEngineDescriptor.getUniqueId();
        List resolvedSegments = engineId.getSegments();
        return uniqueId.getSegments().stream().skip(resolvedSegments.size()).findFirst().filter(suiteSegment -> "suite".equals(suiteSegment.getType())).flatMap(ClassSelectorResolver::tryLoadSuiteClass).filter(this.isSuiteClass).map(suiteClass -> context.addToParent(parent -> this.newSuiteDescriptor((Class<?>)suiteClass, (TestDescriptor)parent)).map(suite -> uniqueId.equals((Object)suite.getUniqueId()) ? suite.addDiscoveryRequestFrom((Class<?>)suiteClass) : suite.addDiscoveryRequestFrom(uniqueId))).map(ClassSelectorResolver::toResolution).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private static Optional<Class<?>> tryLoadSuiteClass(UniqueId.Segment segment) {
        return ReflectionSupport.tryToLoadClass((String)segment.getValue()).toOptional();
    }

    private static SelectorResolver.Resolution toResolution(Optional<SuiteTestDescriptor> suite) {
        return suite.map(SelectorResolver.Match::exact).map(SelectorResolver.Resolution::match).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private Optional<SuiteTestDescriptor> newSuiteDescriptor(Class<?> suiteClass, TestDescriptor parent) {
        UniqueId id = parent.getUniqueId().append("suite", suiteClass.getName());
        if (ClassSelectorResolver.containsCycle(id)) {
            this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.INFO, (String)ClassSelectorResolver.createConfigContainsCycleMessage(suiteClass, id)).source((TestSource)ClassSource.from(suiteClass)));
            return Optional.empty();
        }
        return Optional.of(new SuiteTestDescriptor(id, suiteClass, this.configurationParameters, this.outputDirectoryProvider, this.discoveryListener, this.issueReporter));
    }

    private static boolean containsCycle(UniqueId id) {
        List segments = id.getSegments();
        List engineAndSuiteSegment = segments.subList(segments.size() - 2, segments.size());
        List ancestorSegments = segments.subList(0, segments.size() - 2);
        for (int i = 0; i < ancestorSegments.size() - 1; ++i) {
            List candidate = ancestorSegments.subList(i, i + 2);
            if (!engineAndSuiteSegment.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    private static String createConfigContainsCycleMessage(Class<?> suiteClass, UniqueId suiteId) {
        return "The suite configuration of [%s] resulted in a cycle [%s] and will not be discovered a second time.".formatted(suiteClass.getName(), suiteId);
    }
}

