/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.suite.engine.DiscoverySelectorResolver;
import org.junit.platform.suite.engine.SuiteEngineDescriptor;
import org.junit.platform.suite.engine.SuiteTestDescriptor;

@API(status=API.Status.INTERNAL, since="5.8")
public final class SuiteTestEngine
implements TestEngine {
    public String getId() {
        return "junit-platform-suite";
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.junit.platform");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("junit-platform-suite-engine");
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        SuiteEngineDescriptor engineDescriptor = new SuiteEngineDescriptor(uniqueId);
        new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        SuiteEngineDescriptor suiteEngineDescriptor = (SuiteEngineDescriptor)request.getRootTestDescriptor();
        EngineExecutionListener engineExecutionListener = request.getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)suiteEngineDescriptor);
        suiteEngineDescriptor.getChildren().stream().map(SuiteTestDescriptor.class::cast).forEach(suiteTestDescriptor -> suiteTestDescriptor.execute(engineExecutionListener));
        engineExecutionListener.executionFinished((TestDescriptor)suiteEngineDescriptor, TestExecutionResult.successful());
    }
}

