/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.suite.api.SuiteDisplayName;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.engine.SuiteLauncher;

final class SuiteTestDescriptor
extends AbstractTestDescriptor {
    static final String SEGMENT_TYPE = "suite";
    private final SuiteLauncherDiscoveryRequestBuilder discoveryRequestBuilder = SuiteLauncherDiscoveryRequestBuilder.request();
    private LauncherDiscoveryResult launcherDiscoveryResult;
    private SuiteLauncher launcher;

    SuiteTestDescriptor(UniqueId id, Class<?> suiteClass) {
        super(SuiteTestDescriptor.requireNoCycles(id), SuiteTestDescriptor.getSuiteDisplayName(suiteClass), (TestSource)ClassSource.from(suiteClass));
    }

    private static UniqueId requireNoCycles(UniqueId id) {
        boolean containsCycle = id.getSegments().stream().filter(segment -> SEGMENT_TYPE.equals(segment.getType())).map(UniqueId.Segment::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).values().stream().anyMatch(count -> count > 1L);
        Supplier<String> message = () -> String.format("Configuration error: The suite configuration may not contain a cycle [%s]", id);
        Preconditions.condition((!containsCycle ? 1 : 0) != 0, message);
        return id;
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(Class<?> suiteClass) {
        Preconditions.condition((this.launcherDiscoveryResult == null ? 1 : 0) != 0, (String)"discovery request can not be modified after discovery");
        this.discoveryRequestBuilder.suite(suiteClass);
        return this;
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(UniqueId uniqueId) {
        Preconditions.condition((this.launcherDiscoveryResult == null ? 1 : 0) != 0, (String)"discovery request can not be modified after discovery");
        this.discoveryRequestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((UniqueId)uniqueId)});
        return this;
    }

    void discover() {
        if (this.launcherDiscoveryResult != null) {
            return;
        }
        LauncherDiscoveryRequest request = this.discoveryRequestBuilder.filterStandardClassNamePatterns(true).build();
        this.launcher = SuiteLauncher.create();
        this.launcherDiscoveryResult = this.launcher.discover(request, this.getUniqueId());
        this.launcherDiscoveryResult.getTestEngines().stream().map(testEngine -> this.launcherDiscoveryResult.getEngineTestDescriptor(testEngine)).forEach(arg_0 -> ((SuiteTestDescriptor)this).addChild(arg_0));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static String getSuiteDisplayName(Class<?> testClass) {
        return AnnotationUtils.findAnnotation(testClass, SuiteDisplayName.class).map(SuiteDisplayName::value).filter(StringUtils::isNotBlank).orElse(testClass.getSimpleName());
    }

    void execute(EngineExecutionListener listener) {
        listener.executionStarted((TestDescriptor)this);
        this.launcher.execute(this.launcherDiscoveryResult, listener);
        listener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
    }
}

