/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.engine.LifecycleMethodUtils;
import org.junit.platform.suite.engine.NoTestsDiscoveredException;
import org.junit.platform.suite.engine.SuiteLauncher;

final class SuiteTestDescriptor
extends AbstractTestDescriptor {
    static final String SEGMENT_TYPE = "suite";
    private final SuiteLauncherDiscoveryRequestBuilder discoveryRequestBuilder = SuiteLauncherDiscoveryRequestBuilder.request();
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryProvider outputDirectoryProvider;
    private final Boolean failIfNoTests;
    private final Class<?> suiteClass;
    private final LifecycleMethods lifecycleMethods;
    private LauncherDiscoveryResult launcherDiscoveryResult;
    private SuiteLauncher launcher;

    SuiteTestDescriptor(UniqueId id, Class<?> suiteClass, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider, DiscoveryIssueReporter issueReporter) {
        super(id, SuiteTestDescriptor.getSuiteDisplayName(suiteClass), (TestSource)ClassSource.from(suiteClass));
        this.configurationParameters = configurationParameters;
        this.outputDirectoryProvider = outputDirectoryProvider;
        this.failIfNoTests = SuiteTestDescriptor.getFailIfNoTests(suiteClass);
        this.suiteClass = suiteClass;
        this.lifecycleMethods = new LifecycleMethods(suiteClass, issueReporter);
    }

    private static Boolean getFailIfNoTests(Class<?> suiteClass) {
        return AnnotationSupport.findAnnotation(suiteClass, Suite.class).map(Suite::failIfNoTests).orElseThrow(() -> new JUnitException(String.format("Suite [%s] was not annotated with @Suite", suiteClass.getName())));
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(Class<?> suiteClass) {
        Preconditions.condition((this.launcherDiscoveryResult == null ? 1 : 0) != 0, (String)"discovery request cannot be modified after discovery");
        this.discoveryRequestBuilder.applySelectorsAndFiltersFromSuite(suiteClass);
        return this;
    }

    SuiteTestDescriptor addDiscoveryRequestFrom(UniqueId uniqueId) {
        Preconditions.condition((this.launcherDiscoveryResult == null ? 1 : 0) != 0, (String)"discovery request cannot be modified after discovery");
        this.discoveryRequestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((UniqueId)uniqueId)});
        return this;
    }

    void discover() {
        if (this.launcherDiscoveryResult != null) {
            return;
        }
        LauncherDiscoveryRequest request = this.discoveryRequestBuilder.filterStandardClassNamePatterns(true).enableImplicitConfigurationParameters(false).parentConfigurationParameters(this.configurationParameters).applyConfigurationParametersFromSuite(this.suiteClass).outputDirectoryProvider(this.outputDirectoryProvider).build();
        this.launcher = SuiteLauncher.create();
        this.launcherDiscoveryResult = this.launcher.discover(request, this.getUniqueId());
        this.launcherDiscoveryResult.getTestEngines().stream().map(testEngine -> this.launcherDiscoveryResult.getEngineTestDescriptor(testEngine)).forEach(arg_0 -> ((SuiteTestDescriptor)this).addChild(arg_0));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static String getSuiteDisplayName(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, SuiteDisplayName.class).map(SuiteDisplayName::value).filter(StringUtils::isNotBlank).orElse(testClass.getSimpleName());
    }

    void execute(EngineExecutionListener parentEngineExecutionListener) {
        parentEngineExecutionListener.executionStarted((TestDescriptor)this);
        OpenTest4JAwareThrowableCollector throwableCollector = new OpenTest4JAwareThrowableCollector();
        this.executeBeforeSuiteMethods((ThrowableCollector)throwableCollector);
        TestExecutionSummary summary = this.executeTests(parentEngineExecutionListener, (ThrowableCollector)throwableCollector);
        this.executeAfterSuiteMethods((ThrowableCollector)throwableCollector);
        TestExecutionResult testExecutionResult = this.computeTestExecutionResult(summary, (ThrowableCollector)throwableCollector);
        parentEngineExecutionListener.executionFinished((TestDescriptor)this, testExecutionResult);
    }

    private void executeBeforeSuiteMethods(ThrowableCollector throwableCollector) {
        if (throwableCollector.isNotEmpty()) {
            return;
        }
        for (Method beforeSuiteMethod : this.lifecycleMethods.beforeSuite) {
            throwableCollector.execute(() -> ReflectionSupport.invokeMethod((Method)beforeSuiteMethod, null, (Object[])new Object[0]));
            if (!throwableCollector.isNotEmpty()) continue;
            return;
        }
    }

    private TestExecutionSummary executeTests(EngineExecutionListener parentEngineExecutionListener, ThrowableCollector throwableCollector) {
        if (throwableCollector.isNotEmpty()) {
            return null;
        }
        LauncherDiscoveryResult discoveryResult = this.launcherDiscoveryResult.withRetainedEngines(this.getChildren()::contains);
        return this.launcher.execute(discoveryResult, parentEngineExecutionListener);
    }

    private void executeAfterSuiteMethods(ThrowableCollector throwableCollector) {
        for (Method afterSuiteMethod : this.lifecycleMethods.afterSuite) {
            throwableCollector.execute(() -> ReflectionSupport.invokeMethod((Method)afterSuiteMethod, null, (Object[])new Object[0]));
        }
    }

    private TestExecutionResult computeTestExecutionResult(TestExecutionSummary summary, ThrowableCollector throwableCollector) {
        if (throwableCollector.isNotEmpty()) {
            return TestExecutionResult.failed((Throwable)throwableCollector.getThrowable());
        }
        if (this.failIfNoTests.booleanValue() && summary.getTestsFoundCount() == 0L) {
            return TestExecutionResult.failed((Throwable)((Object)new NoTestsDiscoveredException(this.suiteClass)));
        }
        return TestExecutionResult.successful();
    }

    public boolean mayRegisterTests() {
        return true;
    }

    private static class LifecycleMethods {
        final List<Method> beforeSuite;
        final List<Method> afterSuite;

        LifecycleMethods(Class<?> suiteClass, DiscoveryIssueReporter issueReporter) {
            this.beforeSuite = LifecycleMethodUtils.findBeforeSuiteMethods(suiteClass, issueReporter);
            this.afterSuite = LifecycleMethodUtils.findAfterSuiteMethods(suiteClass, issueReporter);
        }
    }
}

