/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.List;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;

final class DefaultDiscoveryRequest
implements LauncherDiscoveryRequest {
    private final List<DiscoverySelector> selectors;
    private final List<EngineFilter> engineFilters;
    private final List<DiscoveryFilter<?>> discoveryFilters;
    private final List<PostDiscoveryFilter> postDiscoveryFilters;
    private final LauncherConfigurationParameters configurationParameters;
    private final LauncherDiscoveryListener discoveryListener;
    private final OutputDirectoryProvider outputDirectoryProvider;

    DefaultDiscoveryRequest(List<DiscoverySelector> selectors, List<EngineFilter> engineFilters, List<DiscoveryFilter<?>> discoveryFilters, List<PostDiscoveryFilter> postDiscoveryFilters, LauncherConfigurationParameters configurationParameters, LauncherDiscoveryListener discoveryListener, OutputDirectoryProvider outputDirectoryProvider) {
        this.selectors = List.copyOf(selectors);
        this.engineFilters = List.copyOf(engineFilters);
        this.discoveryFilters = List.copyOf(discoveryFilters);
        this.postDiscoveryFilters = List.copyOf(postDiscoveryFilters);
        this.configurationParameters = configurationParameters;
        this.discoveryListener = discoveryListener;
        this.outputDirectoryProvider = outputDirectoryProvider;
    }

    public <T extends DiscoverySelector> List<T> getSelectorsByType(Class<T> selectorType) {
        Preconditions.notNull(selectorType, (String)"selectorType must not be null");
        return this.selectors.stream().filter(selectorType::isInstance).map(selectorType::cast).toList();
    }

    @Override
    public List<EngineFilter> getEngineFilters() {
        return this.engineFilters;
    }

    public <T extends DiscoveryFilter<?>> List<T> getFiltersByType(Class<T> filterType) {
        Preconditions.notNull(filterType, (String)"filterType must not be null");
        return this.discoveryFilters.stream().filter(filterType::isInstance).map(filterType::cast).toList();
    }

    @Override
    public List<PostDiscoveryFilter> getPostDiscoveryFilters() {
        return this.postDiscoveryFilters;
    }

    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    @Override
    public LauncherDiscoveryListener getDiscoveryListener() {
        return this.discoveryListener;
    }

    public OutputDirectoryProvider getOutputDirectoryProvider() {
        return this.outputDirectoryProvider;
    }
}

