/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.store;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class NamespacedHierarchicalStore<N>
implements AutoCloseable {
    private final AtomicInteger insertOrderSequence = new AtomicInteger();
    private final ConcurrentMap<CompositeKey<N>, StoredValue> storedValues = new ConcurrentHashMap<CompositeKey<N>, StoredValue>(4);
    private final @Nullable NamespacedHierarchicalStore<N> parentStore;
    private final @Nullable CloseAction<N> closeAction;
    private volatile boolean closed = false;

    public NamespacedHierarchicalStore(@Nullable NamespacedHierarchicalStore<N> parentStore) {
        this(parentStore, null);
    }

    public NamespacedHierarchicalStore(@Nullable NamespacedHierarchicalStore<N> parentStore, @Nullable CloseAction<N> closeAction) {
        this.parentStore = parentStore;
        this.closeAction = closeAction;
    }

    public NamespacedHierarchicalStore<N> newChild() {
        return new NamespacedHierarchicalStore<N>(this, this.closeAction);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public Optional<NamespacedHierarchicalStore<N>> getParent() {
        return Optional.ofNullable(this.parentStore);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                if (this.closeAction != null) {
                    ThrowableCollector throwableCollector = new ThrowableCollector(__ -> false);
                    this.storedValues.entrySet().stream().map(e -> ((StoredValue)e.getValue()).evaluateSafely((CompositeKey)e.getKey())).filter(it -> it != null && it.value != null).sorted(EvaluatedValue.REVERSE_INSERT_ORDER).forEach(it -> throwableCollector.execute(() -> it.close(this.closeAction)));
                    throwableCollector.assertEmpty();
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public @Nullable Object get(N namespace, Object key) {
        StoredValue storedValue = this.getStoredValue(new CompositeKey<N>(namespace, key));
        return StoredValue.evaluateIfNotNull(storedValue);
    }

    public <T> @Nullable T get(N namespace, Object key, Class<T> requiredType) throws NamespacedHierarchicalStoreException {
        Object value = this.get(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="6.0")
    public <K, V> @Nullable Object getOrComputeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator) {
        Preconditions.notNull(defaultCreator, (String)"defaultCreator must not be null");
        CompositeKey<N> compositeKey = new CompositeKey<N>(namespace, key);
        StoredValue storedValue = this.getStoredValue(compositeKey);
        if (storedValue == null) {
            storedValue = this.storedValues.computeIfAbsent(compositeKey, __ -> this.newStoredValue(new MemoizingSupplier(() -> {
                this.rejectIfClosed();
                return defaultCreator.apply((Object)key);
            })));
        }
        return storedValue.evaluate();
    }

    @API(status=API.Status.MAINTAINED, since="6.0")
    public <K, V> Object computeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator) {
        Preconditions.notNull(defaultCreator, (String)"defaultCreator must not be null");
        CompositeKey<N> compositeKey = new CompositeKey<N>(namespace, key);
        StoredValue storedValue = this.getStoredValue(compositeKey);
        Object result = StoredValue.evaluateIfNotNull(storedValue);
        if (result == null) {
            StoredValue newStoredValue = this.storedValues.compute(compositeKey, (__, oldStoredValue) -> {
                if (StoredValue.evaluateIfNotNull(oldStoredValue) == null) {
                    this.rejectIfClosed();
                    Object computedValue = Preconditions.notNull(defaultCreator.apply((Object)key), (String)"defaultCreator must not return null");
                    return this.newStoredValue(() -> {
                        this.rejectIfClosed();
                        return computedValue;
                    });
                }
                return oldStoredValue;
            });
            return Objects.requireNonNull(newStoredValue.evaluate());
        }
        return result;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="6.0")
    public <K, V> @Nullable V getOrComputeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) throws NamespacedHierarchicalStoreException {
        Object value = this.getOrComputeIfAbsent(namespace, key, defaultCreator);
        return this.castToRequiredType(key, value, requiredType);
    }

    @API(status=API.Status.MAINTAINED, since="6.0")
    public <K, V> V computeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) throws NamespacedHierarchicalStoreException {
        Object value = this.computeIfAbsent(namespace, key, defaultCreator);
        return this.castNonNullToRequiredType(key, value, requiredType);
    }

    public @Nullable Object put(N namespace, Object key, @Nullable Object value) throws NamespacedHierarchicalStoreException {
        this.rejectIfClosed();
        StoredValue oldValue = this.storedValues.put(new CompositeKey<N>(namespace, key), this.newStoredValue(() -> value));
        return StoredValue.evaluateIfNotNull(oldValue);
    }

    public @Nullable Object remove(N namespace, Object key) {
        this.rejectIfClosed();
        StoredValue previous = (StoredValue)this.storedValues.remove(new CompositeKey<N>(namespace, key));
        return StoredValue.evaluateIfNotNull(previous);
    }

    public <T> @Nullable T remove(N namespace, Object key, Class<T> requiredType) throws NamespacedHierarchicalStoreException {
        this.rejectIfClosed();
        Object value = this.remove(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    private StoredValue newStoredValue(Supplier<@Nullable Object> value) {
        return new StoredValue(this.insertOrderSequence.getAndIncrement(), value);
    }

    private @Nullable StoredValue getStoredValue(CompositeKey<N> compositeKey) {
        StoredValue storedValue = (StoredValue)this.storedValues.get(compositeKey);
        if (storedValue != null) {
            return storedValue;
        }
        if (this.parentStore != null) {
            return this.parentStore.getStoredValue(compositeKey);
        }
        return null;
    }

    private <T> @Nullable T castToRequiredType(Object key, @Nullable Object value, Class<T> requiredType) {
        Preconditions.notNull(requiredType, (String)"requiredType must not be null");
        if (value == null) {
            return null;
        }
        return this.castNonNullToRequiredType(key, value, requiredType);
    }

    private <T, V> T castNonNullToRequiredType(Object key, V value, Class<T> requiredType) {
        if (ReflectionUtils.isAssignableTo(value, requiredType)) {
            if (requiredType.isPrimitive()) {
                return Objects.requireNonNull(ReflectionUtils.getWrapperType(requiredType)).cast(value);
            }
            return requiredType.cast(value);
        }
        throw new NamespacedHierarchicalStoreException("Object stored under key [%s] is not of required type [%s], but was [%s]: %s".formatted(key, requiredType.getName(), value.getClass().getName(), value));
    }

    private void rejectIfClosed() {
        if (this.closed) {
            throw new NamespacedHierarchicalStoreException("A NamespacedHierarchicalStore cannot be modified or queried after it has been closed");
        }
    }

    @FunctionalInterface
    public static interface CloseAction<N> {
        @API(status=API.Status.EXPERIMENTAL, since="6.0")
        public static <N> CloseAction<N> closeAutoCloseables() {
            return (__, ___, value) -> {
                if (value instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)value;
                    closeable.close();
                }
            };
        }

        public void close(N var1, Object var2, Object var3) throws Throwable;
    }

    private record EvaluatedValue<N>(CompositeKey<N> compositeKey, int order, @Nullable Object value) {
        private static final Comparator<EvaluatedValue<?>> REVERSE_INSERT_ORDER = Comparator.comparing(it -> it.order).reversed();

        private void close(CloseAction<N> closeAction) throws Throwable {
            if (this.value != null) {
                closeAction.close(this.compositeKey.namespace, this.compositeKey.key, this.value);
            }
        }
    }

    private record CompositeKey<N>(N namespace, Object key) {
        CompositeKey {
            Preconditions.notNull(namespace, (String)"namespace must not be null");
            Preconditions.notNull((Object)key, (String)"key must not be null");
        }
    }

    private record StoredValue(int order, Supplier<@Nullable Object> supplier) {
        private <N> @Nullable EvaluatedValue<N> evaluateSafely(CompositeKey<N> compositeKey) {
            try {
                return new EvaluatedValue<N>(compositeKey, this.order, this.evaluate());
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
                return null;
            }
        }

        private @Nullable Object evaluate() {
            return this.supplier.get();
        }

        static @Nullable Object evaluateIfNotNull(@Nullable StoredValue value) {
            return value != null ? value.evaluate() : null;
        }
    }

    private static class MemoizingSupplier
    implements Supplier<Object> {
        private static final Object NO_VALUE_SET = new Object();
        private final Supplier<@Nullable Object> delegate;
        private volatile @Nullable Object value = NO_VALUE_SET;

        private MemoizingSupplier(Supplier<@Nullable Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public @Nullable Object get() {
            Object object;
            if (this.value == NO_VALUE_SET) {
                this.computeValue();
            }
            if ((object = this.value) instanceof Failure) {
                Failure failure = (Failure)object;
                throw ExceptionUtils.throwAsUncheckedException((Throwable)failure.throwable);
            }
            return this.value;
        }

        private synchronized void computeValue() {
            try {
                if (this.value == NO_VALUE_SET) {
                    this.value = this.delegate.get();
                }
            }
            catch (Throwable t) {
                this.value = new Failure(t);
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
            }
        }

        private record Failure(Throwable throwable) {
        }
    }
}

