/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;

class DiscoverySelectorIdentifierParsers {
    DiscoverySelectorIdentifierParsers() {
    }

    static Stream<? extends DiscoverySelector> parseAll(String ... identifiers) {
        Preconditions.notNull((Object)identifiers, (String)"identifiers must not be null");
        return Stream.of(identifiers).map(DiscoverySelectorIdentifierParsers::parse).flatMap(Optional::stream);
    }

    static Stream<? extends DiscoverySelector> parseAll(Collection<DiscoverySelectorIdentifier> identifiers) {
        Preconditions.notNull(identifiers, (String)"identifiers must not be null");
        return identifiers.stream().map(DiscoverySelectorIdentifierParsers::parse).flatMap(Optional::stream);
    }

    static Optional<? extends DiscoverySelector> parse(String identifier) {
        Preconditions.notNull((Object)identifier, (String)"identifier must not be null");
        return DiscoverySelectorIdentifierParsers.parse(DiscoverySelectorIdentifier.parse(identifier));
    }

    static Optional<? extends DiscoverySelector> parse(DiscoverySelectorIdentifier identifier) {
        Preconditions.notNull((Object)identifier, (String)"identifier must not be null");
        DiscoverySelectorIdentifierParser parser = (DiscoverySelectorIdentifierParser)Preconditions.notNull((Object)Singleton.INSTANCE.parsersByPrefix.get(identifier.getPrefix()), (String)("No parser for prefix: " + identifier.getPrefix()));
        return parser.parse(identifier, DiscoverySelectorIdentifierParsers::parse);
    }

    private static enum Singleton {
        INSTANCE;

        private final Map<String, DiscoverySelectorIdentifierParser> parsersByPrefix;

        private Singleton() {
            HashMap<String, DiscoverySelectorIdentifierParser> parsersByPrefix = new HashMap<String, DiscoverySelectorIdentifierParser>();
            ServiceLoader<DiscoverySelectorIdentifierParser> loadedParsers = ServiceLoader.load(DiscoverySelectorIdentifierParser.class, ClassLoaderUtils.getDefaultClassLoader());
            for (DiscoverySelectorIdentifierParser parser : loadedParsers) {
                DiscoverySelectorIdentifierParser previous = parsersByPrefix.put(parser.getPrefix(), parser);
                Preconditions.condition((previous == null ? 1 : 0) != 0, () -> "Duplicate parser for prefix: [%s]; candidate a: [%s]; candidate b: [%s]".formatted(parser.getPrefix(), Objects.requireNonNull(previous).getClass().getName(), parser.getClass().getName()));
            }
            this.parsersByPrefix = Collections.unmodifiableMap(parsersByPrefix);
        }
    }
}

