/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.junit.platform.engine.support.hierarchical.CompositeLock;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.SingleLock;

class LockManager {
    private static final Comparator<ExclusiveResource> COMPARATOR = Comparator.comparing(ExclusiveResource::getKey).thenComparing(ExclusiveResource::getLockMode);
    private final Map<String, ReadWriteLock> locksByKey = new ConcurrentHashMap<String, ReadWriteLock>();

    LockManager() {
    }

    ResourceLock getLockForResources(Collection<ExclusiveResource> resources) {
        List<Lock> locks = this.getDistinctSortedLocks(resources);
        return this.toResourceLock(locks);
    }

    private List<Lock> getDistinctSortedLocks(Collection<ExclusiveResource> resources) {
        Map resourcesByKey = resources.stream().sorted(COMPARATOR).distinct().collect(Collectors.groupingBy(ExclusiveResource::getKey, LinkedHashMap::new, Collectors.toList()));
        return resourcesByKey.values().stream().map(resourcesWithSameKey -> (ExclusiveResource)resourcesWithSameKey.get(0)).map(resource -> {
            ReadWriteLock lock = this.locksByKey.computeIfAbsent(resource.getKey(), key -> new ReentrantReadWriteLock());
            return resource.getLockMode() == ExclusiveResource.LockMode.READ ? lock.readLock() : lock.writeLock();
        }).collect(Collectors.toList());
    }

    private ResourceLock toResourceLock(List<Lock> locks) {
        int size = locks.size();
        if (size == 0) {
            return NopLock.INSTANCE;
        }
        if (size == 1) {
            return new SingleLock(locks.get(0));
        }
        return new CompositeLock(locks);
    }
}

