/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.net.URI;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.UriSource;

@API(status=API.Status.STABLE, since="1.3")
class DefaultUriSource
implements UriSource {
    private static final long serialVersionUID = 1L;
    private final URI uri;

    DefaultUriSource(URI uri) {
        this.uri = (URI)Preconditions.notNull((Object)uri, (String)"URI must not be null");
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUriSource that = (DefaultUriSource)o;
        return Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uri", (Object)this.uri).toString();
    }
}

