/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;

@API(value=API.Usage.Experimental)
public class CompositeTestSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final List<TestSource> sources;

    public CompositeTestSource(Collection<? extends TestSource> sources) {
        Preconditions.notEmpty(sources, (String)"TestSource collection must not be null or empty");
        Preconditions.containsNoNullElements(sources, (String)"individual TestSources must not be null");
        this.sources = Collections.unmodifiableList(new ArrayList<TestSource>(sources));
    }

    public final List<TestSource> getSources() {
        return this.sources;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeTestSource that = (CompositeTestSource)obj;
        return this.sources.equals(that.sources);
    }

    public int hashCode() {
        return this.sources.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sources", this.sources).toString();
    }
}

