/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.JavaSource;

@API(value=API.Usage.Experimental)
public class JavaClassSource
implements JavaSource {
    private static final long serialVersionUID = 1L;
    private final Class<?> javaClass;

    public JavaClassSource(Class<?> javaClass) {
        this.javaClass = (Class)Preconditions.notNull(javaClass, (String)"class must not be null");
    }

    public final Class<?> getJavaClass() {
        return this.javaClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaClassSource that = (JavaClassSource)o;
        return this.javaClass.equals(that.javaClass);
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("javaClass", (Object)this.javaClass.getName()).toString();
    }
}

