/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.regex.Pattern;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.ClassFilter;

class IncludeClassNameFilter
implements ClassFilter {
    private final Pattern pattern;

    IncludeClassNameFilter(String pattern) {
        Preconditions.notBlank((String)pattern, (String)"pattern must not be null or blank");
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public FilterResult apply(Class<?> clazz) {
        String name = clazz.getName();
        return FilterResult.includedIf(this.pattern.matcher(name).matches(), () -> String.format("Class name [%s] matches pattern: %s", name, this.pattern), () -> String.format("Class name [%s] does not match pattern: %s", name, this.pattern));
    }

    public String toString() {
        return "Includes class names with regular expression: " + this.pattern;
    }
}

