/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;

@API(value=API.Usage.Experimental)
public final class DiscoverySelectors {
    private DiscoverySelectors() {
    }

    public static List<DiscoverySelector> selectClasspathRoots(Set<File> directories) {
        Preconditions.notNull(directories, (String)"directories must not be null");
        return directories.stream().filter(File::isDirectory).map(ClasspathSelector::new).collect(Collectors.toList());
    }

    public static PackageSelector selectPackage(String packageName) {
        Preconditions.notBlank((String)packageName, (String)"Package name must not be null or blank");
        return new PackageSelector(packageName);
    }

    public static ClassSelector selectClass(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        return new ClassSelector(clazz);
    }

    public static ClassSelector selectClass(String className) {
        Preconditions.notBlank((String)className, (String)"className must not be null or blank");
        return DiscoverySelectors.selectClass((Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + className)));
    }

    public static MethodSelector selectMethod(String className, String methodName) {
        Preconditions.notBlank((String)className, (String)"Class name must not be null or blank");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        Class<?> clazz = DiscoverySelectors.loadClass(className);
        return DiscoverySelectors.selectMethod(clazz, DiscoverySelectors.findMethod(clazz, methodName));
    }

    public static MethodSelector selectMethod(Class<?> clazz, String methodName) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        return DiscoverySelectors.selectMethod(clazz, DiscoverySelectors.findMethod(clazz, methodName));
    }

    public static MethodSelector selectMethod(Class<?> clazz, Method method) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Preconditions.notNull((Object)method, (String)"Method must not be null");
        return new MethodSelector(clazz, method);
    }

    public static DiscoverySelector selectName(String name) throws PreconditionViolationException {
        Preconditions.notBlank((String)name, (String)"name must not be null or blank");
        Optional classOptional = ReflectionUtils.loadClass((String)name);
        if (classOptional.isPresent()) {
            return DiscoverySelectors.selectClass((Class)classOptional.get());
        }
        Optional methodOptional = ReflectionUtils.loadMethod((String)name);
        if (methodOptional.isPresent()) {
            Method method = (Method)methodOptional.get();
            return DiscoverySelectors.selectMethod(method.getDeclaringClass(), method);
        }
        if (ReflectionUtils.isPackage((String)name)) {
            return DiscoverySelectors.selectPackage(name);
        }
        throw new PreconditionViolationException(String.format("'%s' specifies neither a class, a method, nor a package.", name));
    }

    public static List<DiscoverySelector> selectNames(String ... names) {
        Preconditions.notNull((Object[])names, (String)"names array must not be null");
        if (names.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(names).map(DiscoverySelectors::selectName).collect(Collectors.toList());
    }

    public static List<DiscoverySelector> selectNames(Collection<String> names) {
        Preconditions.notNull(names, (String)"names collection must not be null");
        return names.stream().map(DiscoverySelectors::selectName).collect(Collectors.toList());
    }

    public static UniqueIdSelector selectUniqueId(UniqueId uniqueId) {
        Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        return new UniqueIdSelector(uniqueId);
    }

    public static UniqueIdSelector selectUniqueId(String uniqueId) {
        Preconditions.notBlank((String)uniqueId, (String)"Unique ID must not be null or blank");
        return new UniqueIdSelector(UniqueId.parse(uniqueId));
    }

    private static Class<?> loadClass(String className) {
        return (Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + className));
    }

    private static Method findMethod(Class<?> clazz, String methodName) {
        return (Method)ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", methodName, clazz.getName())));
    }
}

