/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CompositeFilter;
import org.junit.platform.engine.FilterResult;

@FunctionalInterface
@API(value=API.Usage.Internal)
public interface Filter<T> {
    @SafeVarargs
    public static <T> Filter<T> composeFilters(Filter<T> ... filters) {
        Preconditions.notNull((Object[])filters, (String)"Filters must not be null");
        if (filters.length == 0) {
            return CompositeFilter.alwaysIncluded();
        }
        if (filters.length == 1) {
            return filters[0];
        }
        return new CompositeFilter<T>(Arrays.asList(filters));
    }

    public static <T> Filter<T> composeFilters(Collection<? extends Filter<T>> filters) {
        Preconditions.notNull(filters, (String)"Filters must not be null");
        if (filters.isEmpty()) {
            return CompositeFilter.alwaysIncluded();
        }
        if (filters.size() == 1) {
            return (Filter)CollectionUtils.getOnlyElement(filters);
        }
        return new CompositeFilter(filters);
    }

    public FilterResult apply(T var1);

    default public Predicate<T> toPredicate() {
        return object -> this.apply(object).included();
    }
}

