/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.output;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.console.output.ColorPalette;
import org.junit.platform.console.output.Style;
import org.junit.platform.console.output.Theme;
import org.junit.platform.console.output.TreeNode;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;

class TreePrinter {
    private final PrintWriter out;
    private final Theme theme;
    private final ColorPalette colorPalette;

    TreePrinter(PrintWriter out, Theme theme, ColorPalette colorPalette) {
        this.out = out;
        this.theme = theme;
        this.colorPalette = colorPalette;
    }

    void print(TreeNode node) {
        this.out.println(this.color(Style.CONTAINER, this.theme.root()));
        this.print(node, "", true);
        this.out.flush();
    }

    private void print(TreeNode node, String indent, boolean continuous) {
        if (node.visible) {
            this.printVisible(node, (String)indent, continuous);
        }
        if (node.children.isEmpty()) {
            return;
        }
        if (node.visible) {
            indent = (String)indent + (continuous ? this.theme.vertical() : this.theme.blank());
        }
        Iterator iterator = node.children.iterator();
        while (iterator.hasNext()) {
            this.print((TreeNode)iterator.next(), (String)indent, iterator.hasNext());
        }
    }

    private void printVisible(TreeNode node, String indent, boolean continuous) {
        boolean nodeIsBeingListed;
        String bullet = continuous ? this.theme.entry() : this.theme.end();
        String prefix = this.color(Style.CONTAINER, indent + bullet);
        String tabbed = this.color(Style.CONTAINER, indent + this.tab(node, continuous));
        String caption = this.colorCaption(node);
        String duration = this.color(Style.CONTAINER, node.duration + " ms");
        String icon = this.color(Style.SKIPPED, this.theme.skipped());
        if (node.result().isPresent()) {
            TestExecutionResult result2 = node.result().get();
            Style resultStyle = Style.valueOf(result2);
            icon = this.color(resultStyle, this.theme.status(result2));
        }
        this.out.print(prefix);
        this.out.print(" ");
        this.out.print(caption);
        if (node.duration > 10000L && node.children.isEmpty()) {
            this.out.print(" ");
            this.out.print(duration);
        }
        boolean bl = nodeIsBeingListed = node.duration == 0L && node.result().isEmpty() && node.reason().isEmpty();
        if (!nodeIsBeingListed) {
            this.out.print(" ");
            this.out.print(icon);
        }
        node.result().ifPresent(result -> this.printThrowable(tabbed, (TestExecutionResult)result));
        node.reason().ifPresent(reason -> this.printMessage(Style.SKIPPED, tabbed, (String)reason));
        node.reports.forEach(e -> this.printReportEntry(tabbed, (ReportEntry)e));
        this.out.println();
        node.files.forEach(e -> this.printFileEntry(tabbed, (FileEntry)e));
    }

    private String tab(TreeNode node, boolean continuous) {
        if (node.children.size() > 0) {
            return this.theme.blank() + this.theme.vertical();
        }
        return (continuous ? this.theme.vertical() : this.theme.blank()) + this.theme.blank();
    }

    private String colorCaption(TreeNode node) {
        String caption = node.caption();
        if (node.result().isPresent()) {
            TestExecutionResult result = node.result().get();
            Style resultStyle = Style.valueOf(result);
            if (result.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
                return this.color(resultStyle, caption);
            }
        }
        if (node.reason().isPresent()) {
            return this.color(Style.SKIPPED, caption);
        }
        Style style = node.identifier().map(Style::valueOf).orElse(Style.NONE);
        return this.color(style, caption);
    }

    private void printThrowable(String indent, TestExecutionResult result) {
        if (result.getThrowable().isEmpty()) {
            return;
        }
        Throwable throwable = (Throwable)result.getThrowable().get();
        String message = throwable.getMessage();
        if (StringUtils.isBlank((String)message)) {
            message = throwable.toString();
        }
        this.printMessage(Style.FAILED, indent, message);
    }

    private void printReportEntry(String indent, ReportEntry reportEntry) {
        this.out.println();
        this.out.print(indent);
        this.out.print(reportEntry.getTimestamp());
        Set entries = reportEntry.getKeyValuePairs().entrySet();
        if (entries.size() == 1) {
            this.printReportEntry(" ", (Map.Entry)CollectionUtils.getOnlyElement(entries));
            return;
        }
        for (Map.Entry<String, String> entry : entries) {
            this.out.println();
            this.printReportEntry(indent + this.theme.blank(), entry);
        }
    }

    private void printReportEntry(String indent, Map.Entry<String, String> mapEntry) {
        this.out.print(indent);
        this.out.print(this.color(Style.ABORTED, mapEntry.getKey()));
        this.out.print(" = `");
        this.out.print(this.color(Style.SUCCESSFUL, mapEntry.getValue()));
        this.out.print("`");
    }

    private void printFileEntry(String indent, FileEntry fileEntry) {
        this.out.print(indent);
        this.out.print(fileEntry.getTimestamp());
        this.out.print(" ");
        this.out.print(this.color(Style.SUCCESSFUL, fileEntry.getPath().toUri().toString()));
        this.out.println();
    }

    private void printMessage(Style style, String indent, String message) {
        String[] lines = message.split("\\R");
        this.out.print(" ");
        this.out.print(this.color(style, lines[0]));
        if (lines.length > 1) {
            for (int i = 1; i < lines.length; ++i) {
                this.out.println();
                this.out.print(indent);
                if (!StringUtils.isNotBlank((String)lines[i])) continue;
                String extra = this.theme.blank();
                this.out.print(this.color(style, extra + lines[i]));
            }
        }
    }

    private String color(Style style, String text) {
        return this.colorPalette.paint(style, text);
    }
}

