/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.output;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.console.output.ColorPalette;
import org.junit.platform.console.output.DetailsPrintingListener;
import org.junit.platform.console.output.Theme;
import org.junit.platform.console.output.TreeNode;
import org.junit.platform.console.output.TreePrinter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.INTERNAL, since="6.0")
public class TreePrintingListener
implements DetailsPrintingListener {
    private final Map<UniqueId, TreeNode> nodesByUniqueId = new ConcurrentHashMap<UniqueId, TreeNode>();
    private final TreePrinter treePrinter;
    private @Nullable TreeNode root;

    public TreePrintingListener(PrintWriter out, ColorPalette colorPalette, Theme theme) {
        this.treePrinter = new TreePrinter(out, theme, colorPalette);
    }

    private void addNode(TestIdentifier testIdentifier, TreeNode node) {
        this.nodesByUniqueId.put(testIdentifier.getUniqueIdObject(), node);
        TreeNode parent = testIdentifier.getParentIdObject().map(this.nodesByUniqueId::get).orElse(null);
        Objects.requireNonNullElse(parent, this.root).addChild(node);
    }

    private TreeNode getNode(TestIdentifier testIdentifier) {
        return Objects.requireNonNull(this.nodesByUniqueId.get(testIdentifier.getUniqueIdObject()));
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.root = new TreeNode(testPlan.toString());
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.treePrinter.print(Objects.requireNonNull(this.root));
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.addNode(testIdentifier, new TreeNode(testIdentifier));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.getNode(testIdentifier).setResult(testExecutionResult);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.addNode(testIdentifier, new TreeNode(testIdentifier, reason));
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.getNode(testIdentifier).addReportEntry(entry);
    }

    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry file) {
        this.getNode(testIdentifier).addFileEntry(file);
    }

    @Override
    public void listTests(TestPlan testPlan) {
        this.root = new TreeNode(testPlan.toString());
        testPlan.accept(new TestPlan.Visitor(){

            public void visit(TestIdentifier testIdentifier) {
                TreePrintingListener.this.addNode(testIdentifier, new TreeNode(testIdentifier));
            }
        });
        this.treePrinter.print(this.root);
    }
}

