/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.output;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.output.ColorPalette;
import org.junit.platform.console.output.DetailsPrintingListener;
import org.junit.platform.console.output.Style;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.INTERNAL, since="6.0")
public class TestFeedPrintingListener
implements DetailsPrintingListener {
    private static final String INDENTATION = "\t";
    private static final String STATUS_SEPARATOR = " :: ";
    private final PrintWriter out;
    private final ColorPalette colorPalette;
    private @Nullable TestPlan testPlan;

    public TestFeedPrintingListener(PrintWriter out, ColorPalette colorPalette) {
        this.out = out;
        this.colorPalette = colorPalette;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (TestFeedPrintingListener.shouldPrint(testIdentifier)) {
            String msg = this.formatTestIdentifier(testIdentifier);
            String indentedReason = TestFeedPrintingListener.indented("Reason: %s".formatted(reason));
            this.println(Style.SKIPPED, "%s :: SKIPPED%n\t%s".formatted(msg, indentedReason));
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (TestFeedPrintingListener.shouldPrint(testIdentifier)) {
            String msg = this.formatTestIdentifier(testIdentifier);
            this.println(Style.NONE, "%s :: STARTED".formatted(msg));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        if (testExecutionResult.getThrowable().isPresent()) {
            Style style = Style.valueOf(testExecutionResult);
            String msg = this.formatTestIdentifier(testIdentifier);
            Throwable throwable = (Throwable)testExecutionResult.getThrowable().get();
            String stacktrace = TestFeedPrintingListener.indented(ExceptionUtils.readStackTrace((Throwable)throwable));
            this.println(style, "%s :: %s%n\t%s".formatted(msg, status, stacktrace));
        } else if (TestFeedPrintingListener.shouldPrint(testIdentifier) || testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
            Style style = Style.valueOf(testExecutionResult);
            String msg = this.formatTestIdentifier(testIdentifier);
            this.println(style, "%s :: %s".formatted(msg, status));
        }
    }

    private String formatTestIdentifier(TestIdentifier testIdentifier) {
        return String.join((CharSequence)" > ", this.collectDisplayNames(testIdentifier.getUniqueIdObject()));
    }

    private void println(Style style, String message) {
        this.out.println(this.colorPalette.paint(style, message));
    }

    private List<String> collectDisplayNames(UniqueId uniqueId) {
        int size = uniqueId.getSegments().size();
        ArrayList<String> displayNames = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            displayNames.add(0, Objects.requireNonNull(this.testPlan).getTestIdentifier(uniqueId).getDisplayName());
            if (i >= size - 1) continue;
            uniqueId = uniqueId.removeLastSegment();
        }
        return displayNames;
    }

    private static String indented(String message) {
        return DetailsPrintingListener.indented(message, INDENTATION);
    }

    @Override
    public void listTests(TestPlan testPlan) {
        this.testPlan = testPlan;
        try {
            testPlan.accept(new TestPlan.Visitor(){

                public void visit(TestIdentifier testIdentifier) {
                    if (TestFeedPrintingListener.shouldPrint(testIdentifier)) {
                        TestFeedPrintingListener.this.println(Style.NONE, TestFeedPrintingListener.this.formatTestIdentifier(testIdentifier));
                    }
                }
            });
        }
        finally {
            this.testPlan = null;
        }
    }

    private static boolean shouldPrint(TestIdentifier testIdentifier) {
        return testIdentifier.isTest();
    }
}

