/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.TestConsoleOutputOptions;
import org.junit.platform.console.options.TestDiscoveryOptions;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.ColorPalette;
import org.junit.platform.console.tasks.CustomClassLoaderCloseStrategy;
import org.junit.platform.console.tasks.CustomContextClassLoaderExecutor;
import org.junit.platform.console.tasks.DetailsPrintingListener;
import org.junit.platform.console.tasks.DiscoveryRequestCreator;
import org.junit.platform.console.tasks.FailFastListener;
import org.junit.platform.console.tasks.FlatPrintingListener;
import org.junit.platform.console.tasks.StandardStreamsHandler;
import org.junit.platform.console.tasks.TestFeedPrintingListener;
import org.junit.platform.console.tasks.TreePrintingListener;
import org.junit.platform.console.tasks.VerboseTreePrintingListener;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherExecutionRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;

@API(status=API.Status.INTERNAL, since="1.0")
public class ConsoleTestExecutor {
    private final TestDiscoveryOptions discoveryOptions;
    private final TestConsoleOutputOptions outputOptions;
    private final Supplier<Launcher> launcherSupplier;
    private final CustomClassLoaderCloseStrategy classLoaderCloseStrategy;

    public ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions) {
        this(discoveryOptions, outputOptions, CustomClassLoaderCloseStrategy.CLOSE_AFTER_CALLING_LAUNCHER);
    }

    public ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, CustomClassLoaderCloseStrategy classLoaderCloseStrategy) {
        this(discoveryOptions, outputOptions, classLoaderCloseStrategy, LauncherFactory::create);
    }

    ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, Supplier<Launcher> launcherSupplier) {
        this(discoveryOptions, outputOptions, CustomClassLoaderCloseStrategy.CLOSE_AFTER_CALLING_LAUNCHER, launcherSupplier);
    }

    private ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, CustomClassLoaderCloseStrategy classLoaderCloseStrategy, Supplier<Launcher> launcherSupplier) {
        this.discoveryOptions = discoveryOptions;
        this.outputOptions = outputOptions;
        this.launcherSupplier = launcherSupplier;
        this.classLoaderCloseStrategy = classLoaderCloseStrategy;
    }

    public void discover(PrintWriter out) {
        this.createCustomContextClassLoaderExecutor().invoke(() -> {
            this.discoverTests(out);
            return null;
        });
    }

    public TestExecutionSummary execute(PrintWriter out, Optional<Path> reportsDir, boolean failFast) {
        return this.createCustomContextClassLoaderExecutor().invoke(() -> this.executeTests(out, reportsDir, failFast));
    }

    private CustomContextClassLoaderExecutor createCustomContextClassLoaderExecutor() {
        return new CustomContextClassLoaderExecutor(this.createCustomClassLoader(), this.classLoaderCloseStrategy);
    }

    private void discoverTests(PrintWriter out) {
        Launcher launcher = this.launcherSupplier.get();
        Optional<DetailsPrintingListener> commandLineTestPrinter = this.createDetailsPrintingListener(out);
        LauncherDiscoveryRequest discoveryRequest = DiscoveryRequestCreator.toDiscoveryRequestBuilder(this.discoveryOptions).build();
        TestPlan testPlan = launcher.discover(discoveryRequest);
        commandLineTestPrinter.ifPresent(printer -> printer.listTests(testPlan));
        if (this.outputOptions.getDetails() != Details.NONE) {
            ConsoleTestExecutor.printFoundTestsSummary(out, testPlan);
        }
    }

    private static void printFoundTestsSummary(PrintWriter out, TestPlan testPlan) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        summaryListener.testPlanExecutionStarted(testPlan);
        TestExecutionSummary summary = summaryListener.getSummary();
        out.printf("%n[%10d containers found ]%n[%10d tests found      ]%n%n", summary.getContainersFoundCount(), summary.getTestsFoundCount());
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestExecutionSummary executeTests(PrintWriter out, Optional<Path> reportsDir, boolean failFast) {
        Launcher launcher = this.launcherSupplier.get();
        CancellationToken cancellationToken = failFast ? CancellationToken.create() : null;
        SummaryGeneratingListener summaryListener = this.registerListeners(out, reportsDir, launcher, cancellationToken);
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        try (StandardStreamsHandler standardStreamsHandler = new StandardStreamsHandler();){
            standardStreamsHandler.redirectStandardStreams(this.outputOptions.getStdoutPath(), this.outputOptions.getStderrPath());
            this.launchTests(launcher, reportsDir, cancellationToken);
        }
        finally {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        TestExecutionSummary summary = summaryListener.getSummary();
        if (summary.getTotalFailureCount() > 0L || this.outputOptions.getDetails() != Details.NONE) {
            this.printSummary(summary, out);
        }
        if (cancellationToken != null && cancellationToken.isCancellationRequested()) {
            out.println("Test execution was cancelled due to --fail-fast mode.");
            out.println();
        }
        return summary;
    }

    private void launchTests(Launcher launcher, Optional<Path> reportsDir, @Nullable CancellationToken cancellationToken) {
        LauncherDiscoveryRequestBuilder discoveryRequestBuilder = DiscoveryRequestCreator.toDiscoveryRequestBuilder(this.discoveryOptions);
        reportsDir.ifPresent(dir -> discoveryRequestBuilder.configurationParameter("junit.platform.reporting.output.dir", dir.toAbsolutePath().toString()));
        LauncherExecutionRequest executionRequest = discoveryRequestBuilder.forExecution().cancellationToken(Objects.requireNonNullElseGet(cancellationToken, CancellationToken::disabled)).build();
        launcher.execute(executionRequest);
    }

    private Optional<ClassLoader> createCustomClassLoader() {
        List<Path> additionalClasspathEntries = this.discoveryOptions.getExistingAdditionalClasspathEntries();
        if (!additionalClasspathEntries.isEmpty()) {
            URL[] urls = (URL[])additionalClasspathEntries.stream().map(this::toURL).toArray(URL[]::new);
            ClassLoader parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
            URLClassLoader customClassLoader = URLClassLoader.newInstance(urls, parentClassLoader);
            return Optional.of(customClassLoader);
        }
        return Optional.empty();
    }

    private URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (Exception ex) {
            throw new JUnitException("Invalid classpath entry: " + String.valueOf(path), (Throwable)ex);
        }
    }

    private SummaryGeneratingListener registerListeners(PrintWriter out, Optional<Path> reportsDir, Launcher launcher, @Nullable CancellationToken cancellationToken) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
        Optional<DetailsPrintingListener> optional = this.createDetailsPrintingListener(out);
        Launcher launcher2 = launcher;
        Objects.requireNonNull(launcher2);
        Launcher launcher3 = launcher2;
        optional.ifPresent(xva$0 -> launcher3.registerTestExecutionListeners(new TestExecutionListener[]{xva$0}));
        Optional<TestExecutionListener> optional2 = this.createXmlWritingListener(out, reportsDir);
        Launcher launcher4 = launcher;
        Objects.requireNonNull(launcher4);
        launcher3 = launcher4;
        optional2.ifPresent(xva$0 -> launcher3.registerTestExecutionListeners(new TestExecutionListener[]{xva$0}));
        Optional<TestExecutionListener> optional3 = this.createFailFastListener(cancellationToken);
        Launcher launcher5 = launcher;
        Objects.requireNonNull(launcher5);
        launcher3 = launcher5;
        optional3.ifPresent(xva$0 -> launcher3.registerTestExecutionListeners(new TestExecutionListener[]{xva$0}));
        return summaryListener;
    }

    private Optional<DetailsPrintingListener> createDetailsPrintingListener(PrintWriter out) {
        ColorPalette colorPalette = this.getColorPalette();
        Theme theme = this.outputOptions.getTheme();
        return switch (this.outputOptions.getDetails()) {
            default -> throw new IncompatibleClassChangeError();
            case Details.SUMMARY -> Optional.empty();
            case Details.FLAT -> Optional.of(new FlatPrintingListener(out, colorPalette));
            case Details.TREE -> Optional.of(new TreePrintingListener(out, colorPalette, theme));
            case Details.VERBOSE -> Optional.of(new VerboseTreePrintingListener(out, colorPalette, 16, theme));
            case Details.TESTFEED -> Optional.of(new TestFeedPrintingListener(out, colorPalette));
            case Details.NONE -> Optional.empty();
        };
    }

    private ColorPalette getColorPalette() {
        if (this.outputOptions.isAnsiColorOutputDisabled()) {
            return ColorPalette.NONE;
        }
        if (this.outputOptions.getColorPalettePath() != null) {
            return new ColorPalette(this.outputOptions.getColorPalettePath());
        }
        if (this.outputOptions.isSingleColorPalette()) {
            return ColorPalette.SINGLE_COLOR;
        }
        return ColorPalette.DEFAULT;
    }

    private Optional<TestExecutionListener> createXmlWritingListener(PrintWriter out, Optional<Path> reportsDir) {
        return reportsDir.map(it -> new LegacyXmlReportGeneratingListener(it, out));
    }

    private Optional<TestExecutionListener> createFailFastListener(@Nullable CancellationToken cancellationToken) {
        return Optional.ofNullable(cancellationToken).map(FailFastListener::new);
    }

    private void printSummary(TestExecutionSummary summary, PrintWriter out) {
        if (EnumSet.of(Details.NONE, Details.SUMMARY, Details.TREE).contains((Object)this.outputOptions.getDetails())) {
            summary.printFailuresTo(out);
        }
        summary.printTo(out);
    }

    @FunctionalInterface
    public static interface Factory {
        public ConsoleTestExecutor create(TestDiscoveryOptions var1, TestConsoleOutputOptions var2);
    }
}

