/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;

class TreeNode {
    private final String caption;
    private final long creation;
    long duration;
    private @Nullable String reason;
    private @Nullable TestIdentifier identifier;
    private @Nullable TestExecutionResult result;
    final Queue<ReportEntry> reports = new ConcurrentLinkedQueue<ReportEntry>();
    final Queue<FileEntry> files = new ConcurrentLinkedQueue<FileEntry>();
    final Queue<TreeNode> children = new ConcurrentLinkedQueue<TreeNode>();
    boolean visible;

    TreeNode(String caption) {
        this.caption = caption;
        this.creation = System.currentTimeMillis();
        this.visible = false;
    }

    TreeNode(TestIdentifier identifier) {
        this(TreeNode.createCaption(identifier.getDisplayName()));
        this.identifier = identifier;
        this.visible = true;
    }

    TreeNode(TestIdentifier identifier, String reason) {
        this(identifier);
        this.reason = reason;
    }

    TreeNode addChild(TreeNode node) {
        this.children.add(node);
        return this;
    }

    TreeNode addReportEntry(ReportEntry reportEntry) {
        this.reports.add(reportEntry);
        return this;
    }

    TreeNode addFileEntry(FileEntry file) {
        this.files.add(file);
        return this;
    }

    TreeNode setResult(TestExecutionResult result) {
        this.result = result;
        this.duration = System.currentTimeMillis() - this.creation;
        return this;
    }

    public String caption() {
        return this.caption;
    }

    Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }

    Optional<TestExecutionResult> result() {
        return Optional.ofNullable(this.result);
    }

    Optional<TestIdentifier> identifier() {
        return Optional.ofNullable(this.identifier);
    }

    static String createCaption(String displayName) {
        boolean normal = displayName.length() <= 80;
        String caption = normal ? displayName : displayName.substring(0, 80) + "...";
        String whites = StringUtils.replaceWhitespaceCharacters((String)caption, (String)" ");
        return StringUtils.replaceIsoControlCharacters((String)whites, (String)".");
    }
}

