/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.StringJoiner;
import java.util.stream.StreamSupport;
import org.junit.platform.console.options.BaseCommand;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;

@CommandLine.Command(name="engines", description={"List available test engines"})
class ListTestEnginesCommand
extends BaseCommand<Void> {
    ListTestEnginesCommand() {
    }

    @Override
    protected Void execute(PrintWriter out) {
        this.displayEngines(out);
        return null;
    }

    void displayEngines(PrintWriter out) {
        ServiceLoaderTestEngineRegistry registry = new ServiceLoaderTestEngineRegistry();
        Iterable engines = registry.loadTestEngines();
        StreamSupport.stream(engines.spliterator(), false).sorted(Comparator.comparing(TestEngine::getId)).forEach(engine -> this.displayEngine(out, (TestEngine)engine));
        out.flush();
    }

    private void displayEngine(PrintWriter out, TestEngine engine) {
        StringJoiner details = new StringJoiner(":", " (", ")");
        engine.getGroupId().ifPresent(details::add);
        engine.getArtifactId().ifPresent(details::add);
        engine.getVersion().ifPresent(details::add);
        out.println(this.getColorScheme().string("@|bold %s|@%s".formatted(engine.getId(), details)));
    }
}

