/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ModuleUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.console.options.TestDiscoveryOptions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.MethodFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

class DiscoveryRequestCreator {
    static LauncherDiscoveryRequestBuilder toDiscoveryRequestBuilder(TestDiscoveryOptions options) {
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        List<? extends DiscoverySelector> selectors = DiscoveryRequestCreator.createDiscoverySelectors(options);
        requestBuilder.selectors(selectors);
        DiscoveryRequestCreator.addFilters(requestBuilder, options, selectors);
        requestBuilder.configurationParameters(options.getConfigurationParameters());
        requestBuilder.configurationParametersResources(options.getConfigurationParametersResources().toArray(new String[0]));
        return requestBuilder;
    }

    private static List<? extends DiscoverySelector> createDiscoverySelectors(TestDiscoveryOptions options) {
        List<DiscoverySelector> explicitSelectors = options.getExplicitSelectors();
        if (options.isScanClasspath()) {
            Preconditions.condition((boolean)explicitSelectors.isEmpty(), (String)"Scanning the classpath and using explicit selectors at the same time is not supported");
            return DiscoveryRequestCreator.createClasspathRootSelectors(options);
        }
        if (options.isScanModulepath()) {
            Preconditions.condition((boolean)explicitSelectors.isEmpty(), (String)"Scanning the module-path and using explicit selectors at the same time is not supported");
            return DiscoverySelectors.selectModules((Set)ModuleUtils.findAllNonSystemBootModuleNames());
        }
        return (List)Preconditions.notEmpty(explicitSelectors, (String)"Please specify an explicit selector option or use --scan-class-path or --scan-modules");
    }

    private static List<ClasspathRootSelector> createClasspathRootSelectors(TestDiscoveryOptions options) {
        Set<Path> classpathRoots = DiscoveryRequestCreator.determineClasspathRoots(options);
        return DiscoverySelectors.selectClasspathRoots(classpathRoots);
    }

    private static Set<Path> determineClasspathRoots(TestDiscoveryOptions options) {
        List selectedClasspathEntries = (List)Preconditions.notNull(options.getSelectedClasspathEntries(), () -> "No classpath entries selected");
        if (selectedClasspathEntries.isEmpty()) {
            LinkedHashSet<Path> rootDirs = new LinkedHashSet<Path>(ReflectionUtils.getAllClasspathRootDirectories());
            rootDirs.addAll(options.getExistingAdditionalClasspathEntries());
            return rootDirs;
        }
        return new LinkedHashSet<Path>(selectedClasspathEntries);
    }

    private static void addFilters(LauncherDiscoveryRequestBuilder requestBuilder, TestDiscoveryOptions options, List<? extends DiscoverySelector> selectors) {
        requestBuilder.filters(new Filter[]{DiscoveryRequestCreator.includedClassNamePatterns(options, selectors)});
        if (!options.getExcludedClassNamePatterns().isEmpty()) {
            requestBuilder.filters(new Filter[]{ClassNameFilter.excludeClassNamePatterns((String[])options.getExcludedClassNamePatterns().toArray(new String[0]))});
        }
        if (!options.getIncludedPackages().isEmpty()) {
            requestBuilder.filters(new Filter[]{PackageNameFilter.includePackageNames(options.getIncludedPackages())});
        }
        if (!options.getExcludedPackages().isEmpty()) {
            requestBuilder.filters(new Filter[]{PackageNameFilter.excludePackageNames(options.getExcludedPackages())});
        }
        if (!options.getIncludedMethodNamePatterns().isEmpty()) {
            requestBuilder.filters(new Filter[]{MethodFilter.includeMethodNamePatterns(options.getIncludedMethodNamePatterns())});
        }
        if (!options.getExcludedMethodNamePatterns().isEmpty()) {
            requestBuilder.filters(new Filter[]{MethodFilter.excludeMethodNamePatterns(options.getExcludedMethodNamePatterns())});
        }
        if (!options.getIncludedTagExpressions().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.includeTags(options.getIncludedTagExpressions())});
        }
        if (!options.getExcludedTagExpressions().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.excludeTags(options.getExcludedTagExpressions())});
        }
        if (!options.getIncludedEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.includeEngines(options.getIncludedEngines())});
        }
        if (!options.getExcludedEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines(options.getExcludedEngines())});
        }
    }

    private static ClassNameFilter includedClassNamePatterns(TestDiscoveryOptions options, List<? extends DiscoverySelector> selectors) {
        Stream<String> patternStreams = Stream.concat(options.getIncludedClassNamePatterns().stream(), selectors.stream().map(selector -> {
            DiscoverySelector discoverySelector;
            if (selector instanceof IterationSelector) {
                IterationSelector iterationSelector = (IterationSelector)selector;
                discoverySelector = iterationSelector.getParentSelector();
            } else {
                discoverySelector = selector;
            }
            return discoverySelector;
        }).map(selector -> {
            if (selector instanceof ClassSelector) {
                ClassSelector classSelector = (ClassSelector)selector;
                return classSelector.getClassName();
            }
            if (selector instanceof MethodSelector) {
                MethodSelector methodSelector = (MethodSelector)selector;
                return methodSelector.getClassName();
            }
            return null;
        }).filter(Objects::nonNull).map(Pattern::quote));
        return ClassNameFilter.includeClassNamePatterns((String[])((String[])patternStreams.toArray(String[]::new)));
    }

    private DiscoveryRequestCreator() {
    }
}

