/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;

class StandardStreamsHandler
implements AutoCloseable {
    private @Nullable PrintStream stdout;
    private @Nullable PrintStream stderr;

    public void redirectStandardStreams(@Nullable Path stdoutPath, @Nullable Path stderrPath) {
        if (StandardStreamsHandler.isSameFile(stdoutPath, stderrPath)) {
            try {
                PrintStream commonStream;
                this.stdout = commonStream = new PrintStream(Files.newOutputStream(stdoutPath, new OpenOption[0]), true);
                this.stderr = commonStream;
            }
            catch (IOException ex) {
                throw new JUnitException("Error redirecting stdout and stderr to file: " + String.valueOf(stdoutPath), (Throwable)ex);
            }
        }
        if (stdoutPath != null) {
            try {
                this.stdout = new PrintStream(Files.newOutputStream(stdoutPath, new OpenOption[0]), true);
            }
            catch (IOException ex) {
                throw new JUnitException("Error redirecting stdout to file: " + String.valueOf(stdoutPath), (Throwable)ex);
            }
        }
        if (stderrPath != null) {
            try {
                this.stderr = new PrintStream(Files.newOutputStream(stderrPath, new OpenOption[0]), true);
            }
            catch (IOException ex) {
                throw new JUnitException("Error redirecting stderr to file: " + String.valueOf(stderrPath), (Throwable)ex);
            }
        }
        if (this.stdout != null) {
            System.setOut(this.stdout);
        }
        if (this.stderr != null) {
            System.setErr(this.stderr);
        }
    }

    @Override
    public void close() {
        try {
            if (this.stdout != null) {
                this.stdout.close();
            }
        }
        finally {
            if (this.stderr != null) {
                this.stderr.close();
            }
        }
    }

    private static boolean isSameFile(@Nullable Path path1, @Nullable Path path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        return path1.normalize().toAbsolutePath().equals(path2.normalize().toAbsolutePath());
    }
}

