/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.ColorPalette;
import org.junit.platform.console.tasks.Style;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class VerboseTreePrintingListener
implements TestExecutionListener {
    private final PrintWriter out;
    private final Theme theme;
    private final ColorPalette colorPalette;
    private final Deque<Long> frames;
    private final String[] verticals;
    private long executionStartedMillis;

    VerboseTreePrintingListener(PrintWriter out, ColorPalette colorPalette, int maxContainerNestingLevel, Theme theme) {
        this.out = out;
        this.colorPalette = colorPalette;
        this.theme = theme;
        this.frames = new ArrayDeque<Long>();
        this.frames.push(0L);
        this.verticals = new String[Math.max(10, maxContainerNestingLevel) + 1];
        this.verticals[0] = "";
        this.verticals[1] = "";
        this.verticals[2] = "";
        for (int i = 3; i < this.verticals.length; ++i) {
            this.verticals[i] = this.verticals[i - 1] + theme.vertical();
        }
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.frames.push(System.currentTimeMillis());
        long tests = testPlan.countTestIdentifiers(TestIdentifier::isTest);
        this.printf(Style.NONE, "%s", "Test plan execution started. Number of static tests: ");
        this.printf(Style.TEST, "%d%n", tests);
        this.printf(Style.CONTAINER, "%s%n", this.theme.root());
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.frames.pop();
        long tests = testPlan.countTestIdentifiers(TestIdentifier::isTest);
        this.printf(Style.NONE, "%s", "Test plan execution finished. Number of all tests: ");
        this.printf(Style.TEST, "%d%n", tests);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.executionStartedMillis = System.currentTimeMillis();
        if (testIdentifier.isContainer()) {
            this.printVerticals(this.theme.entry());
            this.printf(Style.CONTAINER, " %s", testIdentifier.getDisplayName());
            this.printf(Style.NONE, "%n", new Object[0]);
            this.frames.push(System.currentTimeMillis());
        }
        if (testIdentifier.isContainer()) {
            return;
        }
        this.printVerticals(this.theme.entry());
        this.printf(Style.valueOf(testIdentifier), " %s%n", testIdentifier.getDisplayName());
        this.printDetails(testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        testExecutionResult.getThrowable().ifPresent(t -> this.printDetail(Style.FAILED, "caught", ExceptionUtils.readStackTrace((Throwable)t), new Object[0]));
        if (testIdentifier.isContainer()) {
            Long creationMillis = this.frames.pop();
            this.printVerticals(this.theme.end());
            this.printf(Style.CONTAINER, " %s", testIdentifier.getDisplayName());
            this.printf(Style.NONE, " finished after %d ms.%n", System.currentTimeMillis() - creationMillis);
            return;
        }
        this.printDetail(Style.NONE, "duration", "%d ms%n", System.currentTimeMillis() - this.executionStartedMillis);
        String status = this.theme.status(testExecutionResult) + " " + testExecutionResult.getStatus();
        this.printDetail(Style.valueOf(testExecutionResult), "status", "%s%n", status);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printVerticals(this.theme.entry());
        this.printf(Style.valueOf(testIdentifier), " %s%n", testIdentifier.getDisplayName());
        this.printDetails(testIdentifier);
        this.printDetail(Style.SKIPPED, "reason", reason, new Object[0]);
        this.printDetail(Style.SKIPPED, "status", this.theme.skipped() + " SKIPPED", new Object[0]);
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.printVerticals(this.theme.entry());
        this.printf(Style.DYNAMIC, " %s", testIdentifier.getDisplayName());
        this.printf(Style.NONE, "%s%n", " dynamically registered");
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.printDetail(Style.REPORTED, "reports", entry.toString(), new Object[0]);
    }

    private void printDetails(TestIdentifier testIdentifier) {
        this.printDetail(Style.NONE, "tags", "%s%n", testIdentifier.getTags());
        this.printDetail(Style.NONE, "uniqueId", "%s%n", testIdentifier.getUniqueId());
        this.printDetail(Style.NONE, "parent", "%s%n", testIdentifier.getParentId().orElse("[]"));
        testIdentifier.getSource().ifPresent(source -> this.printDetail(Style.NONE, "source", "%s%n", source));
    }

    private String verticals() {
        return this.verticals(this.frames.size());
    }

    private String verticals(int index) {
        return this.verticals[Math.min(index, this.verticals.length - 1)];
    }

    private void printVerticals(String tile) {
        this.printf(Style.NONE, this.verticals(), new Object[0]);
        this.printf(Style.NONE, tile, new Object[0]);
    }

    private void printf(Style style, String message, Object ... args) {
        this.out.printf(this.colorPalette.paint(style, message), args);
        this.out.flush();
    }

    private void printDetail(Style style, String detail, String format, Object ... args) {
        String verticals = this.verticals(this.frames.size() + 1);
        this.printf(Style.NONE, verticals, new Object[0]);
        String detailFormat = "%9s";
        if (!detail.isEmpty()) {
            this.printf(Style.NONE, "%s", String.format(detailFormat + ": ", detail));
        }
        if (args.length > 0) {
            this.printf(style, format, args);
            return;
        }
        String[] lines = format.split("\\R");
        this.printf(style, "%s", lines[0]);
        if (lines.length > 1) {
            String delimiter = System.lineSeparator() + verticals + String.format(detailFormat + "    ", "");
            for (int i = 1; i < lines.length; ++i) {
                this.printf(Style.NONE, "%s", delimiter);
                this.printf(style, "%s", lines[i]);
            }
        }
        this.printf(Style.NONE, "%n", new Object[0]);
    }
}

