/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.console.ConsoleLauncherExecutionResult;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.options.PicocliCommandLineOptionsParser;
import org.junit.platform.console.tasks.ConsoleTestExecutor;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(status=API.Status.MAINTAINED, since="1.0")
public class ConsoleLauncher {
    private final CommandLineOptionsParser commandLineOptionsParser;
    private final PrintWriter out;
    private final PrintWriter err;

    public static void main(String ... args) {
        int exitCode = ConsoleLauncher.execute(System.out, System.err, args).getExitCode();
        System.exit(exitCode);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static ConsoleLauncherExecutionResult execute(PrintStream out, PrintStream err, String ... args) {
        return ConsoleLauncher.execute(new PrintWriter(out), new PrintWriter(err), args);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static ConsoleLauncherExecutionResult execute(PrintWriter out, PrintWriter err, String ... args) {
        PicocliCommandLineOptionsParser parser = new PicocliCommandLineOptionsParser();
        ConsoleLauncher consoleLauncher = new ConsoleLauncher(parser, out, err);
        return consoleLauncher.execute(args);
    }

    ConsoleLauncher(CommandLineOptionsParser commandLineOptionsParser, PrintWriter out, PrintWriter err) {
        this.commandLineOptionsParser = commandLineOptionsParser;
        this.out = out;
        this.err = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsoleLauncherExecutionResult execute(String ... args) {
        try {
            CommandLineOptions options = this.commandLineOptionsParser.parse(args);
            if (!options.isBannerDisabled()) {
                this.displayBanner(this.out);
            }
            if (options.isDisplayHelp()) {
                this.commandLineOptionsParser.printHelp(this.out);
                ConsoleLauncherExecutionResult consoleLauncherExecutionResult = ConsoleLauncherExecutionResult.success();
                return consoleLauncherExecutionResult;
            }
            ConsoleLauncherExecutionResult consoleLauncherExecutionResult = this.executeTests(options, this.out);
            return consoleLauncherExecutionResult;
        }
        catch (JUnitException ex) {
            this.err.println(ex.getMessage());
            this.err.println();
            this.commandLineOptionsParser.printHelp(this.err);
            ConsoleLauncherExecutionResult consoleLauncherExecutionResult = ConsoleLauncherExecutionResult.failed();
            return consoleLauncherExecutionResult;
        }
        finally {
            this.out.flush();
            this.err.flush();
        }
    }

    void displayBanner(PrintWriter out) {
        out.println();
        out.println("Thanks for using JUnit! Support its development at https://junit.org/sponsoring");
        out.println();
    }

    private ConsoleLauncherExecutionResult executeTests(CommandLineOptions options, PrintWriter out) {
        try {
            TestExecutionSummary testExecutionSummary = new ConsoleTestExecutor(options).execute(out);
            return ConsoleLauncherExecutionResult.forSummary(testExecutionSummary, options);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.err);
            this.err.println();
            this.commandLineOptionsParser.printHelp(out);
            return ConsoleLauncherExecutionResult.failed();
        }
    }
}

