/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.tasks.Color;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class FlatPrintingListener
implements TestExecutionListener {
    private static final Pattern LINE_START_PATTERN = Pattern.compile("(?m)^");
    static final String INDENTATION = "             ";
    private final PrintWriter out;
    private final boolean disableAnsiColors;

    FlatPrintingListener(PrintWriter out, boolean disableAnsiColors) {
        this.out = out;
        this.disableAnsiColors = disableAnsiColors;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.out.printf("Test execution started. Number of static tests: %d%n", testPlan.countTestIdentifiers(TestIdentifier::isTest));
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.out.println("Test execution finished.");
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Color.DYNAMIC, "Test registered:", testIdentifier);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printlnTestDescriptor(Color.SKIPPED, "Skipped:", testIdentifier);
        this.printlnMessage(Color.SKIPPED, "Reason", reason);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Color.valueOf(testIdentifier), "Started:", testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Color color = Color.valueOf(testExecutionResult);
        this.printlnTestDescriptor(color, "Finished:", testIdentifier);
        testExecutionResult.getThrowable().ifPresent(t -> this.printlnException(color, (Throwable)t));
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.printlnTestDescriptor(Color.REPORTED, "Reported:", testIdentifier);
        this.printlnMessage(Color.REPORTED, "Reported values", entry.toString());
    }

    private void printlnTestDescriptor(Color color, String message, TestIdentifier testIdentifier) {
        this.println(color, "%-10s   %s (%s)", message, testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    private void printlnException(Color color, Throwable throwable) {
        this.printlnMessage(color, "Exception", ExceptionUtils.readStackTrace((Throwable)throwable));
    }

    private void printlnMessage(Color color, String message, String detail) {
        this.println(color, "             => " + message + ": %s", FlatPrintingListener.indented(detail));
    }

    private void println(Color color, String format, Object ... args) {
        this.println(color, String.format(format, args));
    }

    private void println(Color color, String message) {
        if (this.disableAnsiColors) {
            this.out.println(message);
        } else {
            this.out.println((Object)((Object)color) + message + (Object)((Object)Color.NONE));
        }
    }

    private static String indented(String message) {
        return LINE_START_PATTERN.matcher(message).replaceAll(INDENTATION).trim();
    }
}

